/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.EstimateAvailableFullDayTimeOffRequest;
import com.mypurecloud.sdk.v2.model.EstimateAvailablePartialDayTimeOffRequest;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class EstimateAvailableTimeOffRequest
implements Serializable {
    private List<EstimateAvailableFullDayTimeOffRequest> fullDayDates = null;
    private List<EstimateAvailablePartialDayTimeOffRequest> partialDayDates = null;
    private String activityCodeId = null;
    private Boolean paid = null;

    public EstimateAvailableTimeOffRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.fullDayDates = new ArrayList<EstimateAvailableFullDayTimeOffRequest>();
            this.partialDayDates = new ArrayList<EstimateAvailablePartialDayTimeOffRequest>();
        }
    }

    public EstimateAvailableTimeOffRequest fullDayDates(List<EstimateAvailableFullDayTimeOffRequest> fullDayDates) {
        this.fullDayDates = fullDayDates;
        return this;
    }

    @ApiModelProperty(example="null", value="Full day dates. partialDayDates must be empty if this field is populated")
    @JsonProperty(value="fullDayDates")
    public List<EstimateAvailableFullDayTimeOffRequest> getFullDayDates() {
        return this.fullDayDates;
    }

    public void setFullDayDates(List<EstimateAvailableFullDayTimeOffRequest> fullDayDates) {
        this.fullDayDates = fullDayDates;
    }

    public EstimateAvailableTimeOffRequest partialDayDates(List<EstimateAvailablePartialDayTimeOffRequest> partialDayDates) {
        this.partialDayDates = partialDayDates;
        return this;
    }

    @ApiModelProperty(example="null", value="Partial day dates. fullDayDates must be empty if this field is populated")
    @JsonProperty(value="partialDayDates")
    public List<EstimateAvailablePartialDayTimeOffRequest> getPartialDayDates() {
        return this.partialDayDates;
    }

    public void setPartialDayDates(List<EstimateAvailablePartialDayTimeOffRequest> partialDayDates) {
        this.partialDayDates = partialDayDates;
    }

    public EstimateAvailableTimeOffRequest activityCodeId(String activityCodeId) {
        this.activityCodeId = activityCodeId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the activity code associated with the time off request. Activity code must be of the TimeOff category")
    @JsonProperty(value="activityCodeId")
    public String getActivityCodeId() {
        return this.activityCodeId;
    }

    public void setActivityCodeId(String activityCodeId) {
        this.activityCodeId = activityCodeId;
    }

    public EstimateAvailableTimeOffRequest paid(Boolean paid) {
        this.paid = paid;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether this estimate is for a paid time off request")
    @JsonProperty(value="paid")
    public Boolean getPaid() {
        return this.paid;
    }

    public void setPaid(Boolean paid) {
        this.paid = paid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EstimateAvailableTimeOffRequest estimateAvailableTimeOffRequest = (EstimateAvailableTimeOffRequest)o;
        return Objects.equals(this.fullDayDates, estimateAvailableTimeOffRequest.fullDayDates) && Objects.equals(this.partialDayDates, estimateAvailableTimeOffRequest.partialDayDates) && Objects.equals(this.activityCodeId, estimateAvailableTimeOffRequest.activityCodeId) && Objects.equals(this.paid, estimateAvailableTimeOffRequest.paid);
    }

    public int hashCode() {
        return Objects.hash(this.fullDayDates, this.partialDayDates, this.activityCodeId, this.paid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EstimateAvailableTimeOffRequest {\n");
        sb.append("    fullDayDates: ").append(this.toIndentedString(this.fullDayDates)).append("\n");
        sb.append("    partialDayDates: ").append(this.toIndentedString(this.partialDayDates)).append("\n");
        sb.append("    activityCodeId: ").append(this.toIndentedString(this.activityCodeId)).append("\n");
        sb.append("    paid: ").append(this.toIndentedString(this.paid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

