/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ConversationContentIntroduction;
import com.mypurecloud.sdk.v2.model.ConversationContentReceivedReplyMessage;
import com.mypurecloud.sdk.v2.model.ConversationFormPage;
import com.mypurecloud.sdk.v2.model.ConversationFormResponseComponent;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Form content object.")
public class ConversationContentForm
implements Serializable {
    private ConversationContentIntroduction introduction = null;
    private List<ConversationFormPage> formPages = null;
    private ConversationContentReceivedReplyMessage receivedMessage = null;
    private ConversationContentReceivedReplyMessage replyMessage = null;
    private Boolean showSummary = null;
    private List<ConversationFormResponseComponent> response = null;
    private String originatingMessageId = null;
    private String cannedResponseId = null;

    public ConversationContentForm() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.formPages = new ArrayList<ConversationFormPage>();
            this.response = new ArrayList<ConversationFormResponseComponent>();
        }
    }

    public ConversationContentForm introduction(ConversationContentIntroduction introduction) {
        this.introduction = introduction;
        return this;
    }

    @ApiModelProperty(example="null", value="The intro component, used to give an intro into what the form entails")
    @JsonProperty(value="introduction")
    public ConversationContentIntroduction getIntroduction() {
        return this.introduction;
    }

    public void setIntroduction(ConversationContentIntroduction introduction) {
        this.introduction = introduction;
    }

    public ConversationContentForm formPages(List<ConversationFormPage> formPages) {
        this.formPages = formPages;
        return this;
    }

    @ApiModelProperty(example="null", value="Form pages")
    @JsonProperty(value="formPages")
    public List<ConversationFormPage> getFormPages() {
        return this.formPages;
    }

    public void setFormPages(List<ConversationFormPage> formPages) {
        this.formPages = formPages;
    }

    public ConversationContentForm receivedMessage(ConversationContentReceivedReplyMessage receivedMessage) {
        this.receivedMessage = receivedMessage;
        return this;
    }

    @ApiModelProperty(example="null", value="The message prompt to fill out the form received.")
    @JsonProperty(value="receivedMessage")
    public ConversationContentReceivedReplyMessage getReceivedMessage() {
        return this.receivedMessage;
    }

    public void setReceivedMessage(ConversationContentReceivedReplyMessage receivedMessage) {
        this.receivedMessage = receivedMessage;
    }

    public ConversationContentForm replyMessage(ConversationContentReceivedReplyMessage replyMessage) {
        this.replyMessage = replyMessage;
        return this;
    }

    @ApiModelProperty(example="null", value="The reply message after the user has filled out the form received.")
    @JsonProperty(value="replyMessage")
    public ConversationContentReceivedReplyMessage getReplyMessage() {
        return this.replyMessage;
    }

    public void setReplyMessage(ConversationContentReceivedReplyMessage replyMessage) {
        this.replyMessage = replyMessage;
    }

    public ConversationContentForm showSummary(Boolean showSummary) {
        this.showSummary = showSummary;
        return this;
    }

    @ApiModelProperty(example="null", value="Show summary at end of form submission.")
    @JsonProperty(value="showSummary")
    public Boolean getShowSummary() {
        return this.showSummary;
    }

    public void setShowSummary(Boolean showSummary) {
        this.showSummary = showSummary;
    }

    public ConversationContentForm response(List<ConversationFormResponseComponent> response) {
        this.response = response;
        return this;
    }

    @ApiModelProperty(example="null", value="Content of the payload included in the Form response.")
    @JsonProperty(value="response")
    public List<ConversationFormResponseComponent> getResponse() {
        return this.response;
    }

    public void setResponse(List<ConversationFormResponseComponent> response) {
        this.response = response;
    }

    public ConversationContentForm originatingMessageId(String originatingMessageId) {
        this.originatingMessageId = originatingMessageId;
        return this;
    }

    @ApiModelProperty(example="null", value="Reference to the ID of the original message.")
    @JsonProperty(value="originatingMessageId")
    public String getOriginatingMessageId() {
        return this.originatingMessageId;
    }

    public void setOriginatingMessageId(String originatingMessageId) {
        this.originatingMessageId = originatingMessageId;
    }

    public ConversationContentForm cannedResponseId(String cannedResponseId) {
        this.cannedResponseId = cannedResponseId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The id of the canned response which was used to create the form.")
    @JsonProperty(value="cannedResponseId")
    public String getCannedResponseId() {
        return this.cannedResponseId;
    }

    public void setCannedResponseId(String cannedResponseId) {
        this.cannedResponseId = cannedResponseId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationContentForm conversationContentForm = (ConversationContentForm)o;
        return Objects.equals(this.introduction, conversationContentForm.introduction) && Objects.equals(this.formPages, conversationContentForm.formPages) && Objects.equals(this.receivedMessage, conversationContentForm.receivedMessage) && Objects.equals(this.replyMessage, conversationContentForm.replyMessage) && Objects.equals(this.showSummary, conversationContentForm.showSummary) && Objects.equals(this.response, conversationContentForm.response) && Objects.equals(this.originatingMessageId, conversationContentForm.originatingMessageId) && Objects.equals(this.cannedResponseId, conversationContentForm.cannedResponseId);
    }

    public int hashCode() {
        return Objects.hash(this.introduction, this.formPages, this.receivedMessage, this.replyMessage, this.showSummary, this.response, this.originatingMessageId, this.cannedResponseId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationContentForm {\n");
        sb.append("    introduction: ").append(this.toIndentedString(this.introduction)).append("\n");
        sb.append("    formPages: ").append(this.toIndentedString(this.formPages)).append("\n");
        sb.append("    receivedMessage: ").append(this.toIndentedString(this.receivedMessage)).append("\n");
        sb.append("    replyMessage: ").append(this.toIndentedString(this.replyMessage)).append("\n");
        sb.append("    showSummary: ").append(this.toIndentedString(this.showSummary)).append("\n");
        sb.append("    response: ").append(this.toIndentedString(this.response)).append("\n");
        sb.append("    originatingMessageId: ").append(this.toIndentedString(this.originatingMessageId)).append("\n");
        sb.append("    cannedResponseId: ").append(this.toIndentedString(this.cannedResponseId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

