/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ConversationContentDatePickerAvailableTime;
import com.mypurecloud.sdk.v2.model.ConversationContentLocation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@ApiModel(description="DateTimePicker content object.")
public class ConversationContentDatePicker
implements Serializable {
    private String id = null;
    private String title = null;
    private String subtitle = null;
    private String imageUrl = null;
    private Date dateMinimum = null;
    private Date dateMaximum = null;
    private ConversationContentLocation location = null;
    private List<ConversationContentDatePickerAvailableTime> availableTimes = null;
    private DateDisplayFormatEnum dateDisplayFormat = null;

    public ConversationContentDatePicker() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.availableTimes = new ArrayList<ConversationContentDatePickerAvailableTime>();
        }
    }

    public ConversationContentDatePicker id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="Optional unique identifier to help map component replies to form messages where multiple DatePickers can be present.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ConversationContentDatePicker title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="null", value="Text to show in the title.")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ConversationContentDatePicker subtitle(String subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    @ApiModelProperty(example="null", value="Text to show in the description.")
    @JsonProperty(value="subtitle")
    public String getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public ConversationContentDatePicker imageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
        return this;
    }

    @ApiModelProperty(example="null", value="URL of an image")
    @JsonProperty(value="imageUrl")
    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public ConversationContentDatePicker dateMinimum(Date dateMinimum) {
        this.dateMinimum = dateMinimum;
        return this;
    }

    @ApiModelProperty(example="null", value="The minimum Date Enabled in the datepicker calendar, format: ISO 8601.")
    @JsonProperty(value="dateMinimum")
    public Date getDateMinimum() {
        return this.dateMinimum;
    }

    public void setDateMinimum(Date dateMinimum) {
        this.dateMinimum = dateMinimum;
    }

    public ConversationContentDatePicker dateMaximum(Date dateMaximum) {
        this.dateMaximum = dateMaximum;
        return this;
    }

    @ApiModelProperty(example="null", value="The maximum Date Enabled in the datepicker calendar, format: ISO 8601.")
    @JsonProperty(value="dateMaximum")
    public Date getDateMaximum() {
        return this.dateMaximum;
    }

    public void setDateMaximum(Date dateMaximum) {
        this.dateMaximum = dateMaximum;
    }

    public ConversationContentDatePicker location(ConversationContentLocation location) {
        this.location = location;
        return this;
    }

    @ApiModelProperty(example="null", value="Location of the event.")
    @JsonProperty(value="location")
    public ConversationContentLocation getLocation() {
        return this.location;
    }

    public void setLocation(ConversationContentLocation location) {
        this.location = location;
    }

    public ConversationContentDatePicker availableTimes(List<ConversationContentDatePickerAvailableTime> availableTimes) {
        this.availableTimes = availableTimes;
        return this;
    }

    @ApiModelProperty(example="null", value="An array of available times objects.")
    @JsonProperty(value="availableTimes")
    public List<ConversationContentDatePickerAvailableTime> getAvailableTimes() {
        return this.availableTimes;
    }

    public void setAvailableTimes(List<ConversationContentDatePickerAvailableTime> availableTimes) {
        this.availableTimes = availableTimes;
    }

    public ConversationContentDatePicker dateDisplayFormat(DateDisplayFormatEnum dateDisplayFormat) {
        this.dateDisplayFormat = dateDisplayFormat;
        return this;
    }

    @ApiModelProperty(example="null", value="The format the date should be presented to the end user.")
    @JsonProperty(value="dateDisplayFormat")
    public DateDisplayFormatEnum getDateDisplayFormat() {
        return this.dateDisplayFormat;
    }

    public void setDateDisplayFormat(DateDisplayFormatEnum dateDisplayFormat) {
        this.dateDisplayFormat = dateDisplayFormat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationContentDatePicker conversationContentDatePicker = (ConversationContentDatePicker)o;
        return Objects.equals(this.id, conversationContentDatePicker.id) && Objects.equals(this.title, conversationContentDatePicker.title) && Objects.equals(this.subtitle, conversationContentDatePicker.subtitle) && Objects.equals(this.imageUrl, conversationContentDatePicker.imageUrl) && Objects.equals(this.dateMinimum, conversationContentDatePicker.dateMinimum) && Objects.equals(this.dateMaximum, conversationContentDatePicker.dateMaximum) && Objects.equals(this.location, conversationContentDatePicker.location) && Objects.equals(this.availableTimes, conversationContentDatePicker.availableTimes) && Objects.equals((Object)this.dateDisplayFormat, (Object)conversationContentDatePicker.dateDisplayFormat);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.title, this.subtitle, this.imageUrl, this.dateMinimum, this.dateMaximum, this.location, this.availableTimes, this.dateDisplayFormat});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationContentDatePicker {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    subtitle: ").append(this.toIndentedString(this.subtitle)).append("\n");
        sb.append("    imageUrl: ").append(this.toIndentedString(this.imageUrl)).append("\n");
        sb.append("    dateMinimum: ").append(this.toIndentedString(this.dateMinimum)).append("\n");
        sb.append("    dateMaximum: ").append(this.toIndentedString(this.dateMaximum)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    availableTimes: ").append(this.toIndentedString(this.availableTimes)).append("\n");
        sb.append("    dateDisplayFormat: ").append(this.toIndentedString((Object)this.dateDisplayFormat)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=DateDisplayFormatEnumDeserializer.class)
    public static enum DateDisplayFormatEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DAYMONTHYEAR("dayMonthYear"),
        MONTHDAYYEAR("monthDayYear"),
        YEARMONTHDAY("yearMonthDay");

        private String value;

        private DateDisplayFormatEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DateDisplayFormatEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DateDisplayFormatEnum value : DateDisplayFormatEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DateDisplayFormatEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DateDisplayFormatEnumDeserializer
    extends StdDeserializer<DateDisplayFormatEnum> {
        public DateDisplayFormatEnumDeserializer() {
            super(DateDisplayFormatEnumDeserializer.class);
        }

        public DateDisplayFormatEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DateDisplayFormatEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

