/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.SetWrapperString;
import com.mypurecloud.sdk.v2.model.UpdateTimeOffPlanBusinessUnitAssociation;
import com.mypurecloud.sdk.v2.model.UpdateTimeOffPlanManagementUnitAssociation;
import com.mypurecloud.sdk.v2.model.ValueWrapperHrisTimeOffType;
import com.mypurecloud.sdk.v2.model.WfmVersionedEntityMetadata;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class BuUpdateTimeOffPlanRequest
implements Serializable {
    private String name = null;
    private SetWrapperString activityCodeIds = null;
    private AutoApprovalRuleEnum autoApprovalRule = null;
    private Integer daysBeforeStartToExpireFromWaitlist = null;
    private ValueWrapperHrisTimeOffType hrisTimeOffType = null;
    private Boolean enabled = null;
    private Boolean countAgainstTimeOffLimits = null;
    private UpdateTimeOffPlanBusinessUnitAssociation businessUnitAssociation = null;
    private UpdateTimeOffPlanManagementUnitAssociation managementUnitAssociation = null;
    private WfmVersionedEntityMetadata metadata = null;

    public BuUpdateTimeOffPlanRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public BuUpdateTimeOffPlanRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of this time-off plan")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BuUpdateTimeOffPlanRequest activityCodeIds(SetWrapperString activityCodeIds) {
        this.activityCodeIds = activityCodeIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The IDs of activity codes to associate with this time-off plan")
    @JsonProperty(value="activityCodeIds")
    public SetWrapperString getActivityCodeIds() {
        return this.activityCodeIds;
    }

    public void setActivityCodeIds(SetWrapperString activityCodeIds) {
        this.activityCodeIds = activityCodeIds;
    }

    public BuUpdateTimeOffPlanRequest autoApprovalRule(AutoApprovalRuleEnum autoApprovalRule) {
        this.autoApprovalRule = autoApprovalRule;
        return this;
    }

    @ApiModelProperty(example="null", value="Auto approval rule for this time-off plan")
    @JsonProperty(value="autoApprovalRule")
    public AutoApprovalRuleEnum getAutoApprovalRule() {
        return this.autoApprovalRule;
    }

    public void setAutoApprovalRule(AutoApprovalRuleEnum autoApprovalRule) {
        this.autoApprovalRule = autoApprovalRule;
    }

    public BuUpdateTimeOffPlanRequest daysBeforeStartToExpireFromWaitlist(Integer daysBeforeStartToExpireFromWaitlist) {
        this.daysBeforeStartToExpireFromWaitlist = daysBeforeStartToExpireFromWaitlist;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of days before the time-off request start date for when the request will be expired from the waitlist")
    @JsonProperty(value="daysBeforeStartToExpireFromWaitlist")
    public Integer getDaysBeforeStartToExpireFromWaitlist() {
        return this.daysBeforeStartToExpireFromWaitlist;
    }

    public void setDaysBeforeStartToExpireFromWaitlist(Integer daysBeforeStartToExpireFromWaitlist) {
        this.daysBeforeStartToExpireFromWaitlist = daysBeforeStartToExpireFromWaitlist;
    }

    public BuUpdateTimeOffPlanRequest hrisTimeOffType(ValueWrapperHrisTimeOffType hrisTimeOffType) {
        this.hrisTimeOffType = hrisTimeOffType;
        return this;
    }

    @ApiModelProperty(example="null", value="Time-off type, if this time-off plan is associated with the integration")
    @JsonProperty(value="hrisTimeOffType")
    public ValueWrapperHrisTimeOffType getHrisTimeOffType() {
        return this.hrisTimeOffType;
    }

    public void setHrisTimeOffType(ValueWrapperHrisTimeOffType hrisTimeOffType) {
        this.hrisTimeOffType = hrisTimeOffType;
    }

    public BuUpdateTimeOffPlanRequest enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this time-off plan should be used by agents")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public BuUpdateTimeOffPlanRequest countAgainstTimeOffLimits(Boolean countAgainstTimeOffLimits) {
        this.countAgainstTimeOffLimits = countAgainstTimeOffLimits;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this time-off plan should count against time-off limits")
    @JsonProperty(value="countAgainstTimeOffLimits")
    public Boolean getCountAgainstTimeOffLimits() {
        return this.countAgainstTimeOffLimits;
    }

    public void setCountAgainstTimeOffLimits(Boolean countAgainstTimeOffLimits) {
        this.countAgainstTimeOffLimits = countAgainstTimeOffLimits;
    }

    public BuUpdateTimeOffPlanRequest businessUnitAssociation(UpdateTimeOffPlanBusinessUnitAssociation businessUnitAssociation) {
        this.businessUnitAssociation = businessUnitAssociation;
        return this;
    }

    @ApiModelProperty(example="null", value="Business unit association, if the time-off plan belongs to a business unit. managementUnitAssociation must not be set if this is populated")
    @JsonProperty(value="businessUnitAssociation")
    public UpdateTimeOffPlanBusinessUnitAssociation getBusinessUnitAssociation() {
        return this.businessUnitAssociation;
    }

    public void setBusinessUnitAssociation(UpdateTimeOffPlanBusinessUnitAssociation businessUnitAssociation) {
        this.businessUnitAssociation = businessUnitAssociation;
    }

    public BuUpdateTimeOffPlanRequest managementUnitAssociation(UpdateTimeOffPlanManagementUnitAssociation managementUnitAssociation) {
        this.managementUnitAssociation = managementUnitAssociation;
        return this;
    }

    @ApiModelProperty(example="null", value="Management unit association, if the time-off plan belongs to a management unit. businessUnitAssociation must not be set if this is populated")
    @JsonProperty(value="managementUnitAssociation")
    public UpdateTimeOffPlanManagementUnitAssociation getManagementUnitAssociation() {
        return this.managementUnitAssociation;
    }

    public void setManagementUnitAssociation(UpdateTimeOffPlanManagementUnitAssociation managementUnitAssociation) {
        this.managementUnitAssociation = managementUnitAssociation;
    }

    public BuUpdateTimeOffPlanRequest metadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Version metadata for this time-off plan")
    @JsonProperty(value="metadata")
    public WfmVersionedEntityMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuUpdateTimeOffPlanRequest buUpdateTimeOffPlanRequest = (BuUpdateTimeOffPlanRequest)o;
        return Objects.equals(this.name, buUpdateTimeOffPlanRequest.name) && Objects.equals(this.activityCodeIds, buUpdateTimeOffPlanRequest.activityCodeIds) && Objects.equals((Object)this.autoApprovalRule, (Object)buUpdateTimeOffPlanRequest.autoApprovalRule) && Objects.equals(this.daysBeforeStartToExpireFromWaitlist, buUpdateTimeOffPlanRequest.daysBeforeStartToExpireFromWaitlist) && Objects.equals(this.hrisTimeOffType, buUpdateTimeOffPlanRequest.hrisTimeOffType) && Objects.equals(this.enabled, buUpdateTimeOffPlanRequest.enabled) && Objects.equals(this.countAgainstTimeOffLimits, buUpdateTimeOffPlanRequest.countAgainstTimeOffLimits) && Objects.equals(this.businessUnitAssociation, buUpdateTimeOffPlanRequest.businessUnitAssociation) && Objects.equals(this.managementUnitAssociation, buUpdateTimeOffPlanRequest.managementUnitAssociation) && Objects.equals(this.metadata, buUpdateTimeOffPlanRequest.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.activityCodeIds, this.autoApprovalRule, this.daysBeforeStartToExpireFromWaitlist, this.hrisTimeOffType, this.enabled, this.countAgainstTimeOffLimits, this.businessUnitAssociation, this.managementUnitAssociation, this.metadata});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BuUpdateTimeOffPlanRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    activityCodeIds: ").append(this.toIndentedString(this.activityCodeIds)).append("\n");
        sb.append("    autoApprovalRule: ").append(this.toIndentedString((Object)this.autoApprovalRule)).append("\n");
        sb.append("    daysBeforeStartToExpireFromWaitlist: ").append(this.toIndentedString(this.daysBeforeStartToExpireFromWaitlist)).append("\n");
        sb.append("    hrisTimeOffType: ").append(this.toIndentedString(this.hrisTimeOffType)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    countAgainstTimeOffLimits: ").append(this.toIndentedString(this.countAgainstTimeOffLimits)).append("\n");
        sb.append("    businessUnitAssociation: ").append(this.toIndentedString(this.businessUnitAssociation)).append("\n");
        sb.append("    managementUnitAssociation: ").append(this.toIndentedString(this.managementUnitAssociation)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=AutoApprovalRuleEnumDeserializer.class)
    public static enum AutoApprovalRuleEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NEVER("Never"),
        ALWAYS("Always"),
        CHECKLIMITS("CheckLimits"),
        CHECKACTIVITYCODES("CheckActivityCodes"),
        CHECKLIMITSANDACTIVITYCODES("CheckLimitsAndActivityCodes");

        private String value;

        private AutoApprovalRuleEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AutoApprovalRuleEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AutoApprovalRuleEnum value : AutoApprovalRuleEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AutoApprovalRuleEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class AutoApprovalRuleEnumDeserializer
    extends StdDeserializer<AutoApprovalRuleEnum> {
        public AutoApprovalRuleEnumDeserializer() {
            super(AutoApprovalRuleEnumDeserializer.class);
        }

        public AutoApprovalRuleEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AutoApprovalRuleEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

