/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;

public class BillingPlanItem
implements Serializable {
    private String itemNumber = null;
    private String name = null;
    private String type = null;
    private String function = null;
    private String description = null;
    private LocalDate dateChargedThrough = null;
    private String currencyIsoCode = null;
    private BigDecimal discountAmount = null;
    private LocalDate dateEffectiveStart = null;
    private LocalDate dateEffectiveEnd = null;
    private BigDecimal overagePrice = null;
    private BigDecimal price = null;
    private Integer quantity = null;
    private UnitOfMeasureEnum unitOfMeasure = null;

    public BillingPlanItem() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public BillingPlanItem itemNumber(String itemNumber) {
        this.itemNumber = itemNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="Item number.")
    @JsonProperty(value="itemNumber")
    public String getItemNumber() {
        return this.itemNumber;
    }

    public void setItemNumber(String itemNumber) {
        this.itemNumber = itemNumber;
    }

    public BillingPlanItem name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="Name of the item.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BillingPlanItem type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="Type of the item.")
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public BillingPlanItem function(String function) {
        this.function = function;
        return this;
    }

    @ApiModelProperty(example="null", value="Function of the item.")
    @JsonProperty(value="function")
    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public BillingPlanItem description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="Detailed description of the item.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BillingPlanItem dateChargedThrough(LocalDate dateChargedThrough) {
        this.dateChargedThrough = dateChargedThrough;
        return this;
    }

    @ApiModelProperty(example="null", value="The date through which a customer has been billed for the charge. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateChargedThrough")
    public LocalDate getDateChargedThrough() {
        return this.dateChargedThrough;
    }

    public void setDateChargedThrough(LocalDate dateChargedThrough) {
        this.dateChargedThrough = dateChargedThrough;
    }

    public BillingPlanItem currencyIsoCode(String currencyIsoCode) {
        this.currencyIsoCode = currencyIsoCode;
        return this;
    }

    @ApiModelProperty(example="null", value="Contains the ISO code for any currency allowed by the organization.")
    @JsonProperty(value="currencyIsoCode")
    public String getCurrencyIsoCode() {
        return this.currencyIsoCode;
    }

    public void setCurrencyIsoCode(String currencyIsoCode) {
        this.currencyIsoCode = currencyIsoCode;
    }

    public BillingPlanItem discountAmount(BigDecimal discountAmount) {
        this.discountAmount = discountAmount;
        return this;
    }

    @ApiModelProperty(example="null", value="The amount of the discount.")
    @JsonProperty(value="discountAmount")
    public BigDecimal getDiscountAmount() {
        return this.discountAmount;
    }

    public void setDiscountAmount(BigDecimal discountAmount) {
        this.discountAmount = discountAmount;
    }

    public BillingPlanItem dateEffectiveStart(LocalDate dateEffectiveStart) {
        this.dateEffectiveStart = dateEffectiveStart;
        return this;
    }

    @ApiModelProperty(example="null", value="The date when the Address became effective. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateEffectiveStart")
    public LocalDate getDateEffectiveStart() {
        return this.dateEffectiveStart;
    }

    public void setDateEffectiveStart(LocalDate dateEffectiveStart) {
        this.dateEffectiveStart = dateEffectiveStart;
    }

    public BillingPlanItem dateEffectiveEnd(LocalDate dateEffectiveEnd) {
        this.dateEffectiveEnd = dateEffectiveEnd;
        return this;
    }

    @ApiModelProperty(example="null", value="The date when the Address became effective. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateEffectiveEnd")
    public LocalDate getDateEffectiveEnd() {
        return this.dateEffectiveEnd;
    }

    public void setDateEffectiveEnd(LocalDate dateEffectiveEnd) {
        this.dateEffectiveEnd = dateEffectiveEnd;
    }

    public BillingPlanItem overagePrice(BigDecimal overagePrice) {
        this.overagePrice = overagePrice;
        return this;
    }

    @ApiModelProperty(example="null", value="The price for units over the allowed amount.")
    @JsonProperty(value="overagePrice")
    public BigDecimal getOveragePrice() {
        return this.overagePrice;
    }

    public void setOveragePrice(BigDecimal overagePrice) {
        this.overagePrice = overagePrice;
    }

    public BillingPlanItem price(BigDecimal price) {
        this.price = price;
        return this;
    }

    @ApiModelProperty(example="null", value="The price associated with the item expressed as a decimal.")
    @JsonProperty(value="price")
    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BillingPlanItem quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(example="null", value="The quantity of units.")
    @JsonProperty(value="quantity")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public BillingPlanItem unitOfMeasure(UnitOfMeasureEnum unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @ApiModelProperty(example="null", value="The unit of measure for the wallet.")
    @JsonProperty(value="unitOfMeasure")
    public UnitOfMeasureEnum getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(UnitOfMeasureEnum unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillingPlanItem billingPlanItem = (BillingPlanItem)o;
        return Objects.equals(this.itemNumber, billingPlanItem.itemNumber) && Objects.equals(this.name, billingPlanItem.name) && Objects.equals(this.type, billingPlanItem.type) && Objects.equals(this.function, billingPlanItem.function) && Objects.equals(this.description, billingPlanItem.description) && Objects.equals(this.dateChargedThrough, billingPlanItem.dateChargedThrough) && Objects.equals(this.currencyIsoCode, billingPlanItem.currencyIsoCode) && Objects.equals(this.discountAmount, billingPlanItem.discountAmount) && Objects.equals(this.dateEffectiveStart, billingPlanItem.dateEffectiveStart) && Objects.equals(this.dateEffectiveEnd, billingPlanItem.dateEffectiveEnd) && Objects.equals(this.overagePrice, billingPlanItem.overagePrice) && Objects.equals(this.price, billingPlanItem.price) && Objects.equals(this.quantity, billingPlanItem.quantity) && Objects.equals((Object)this.unitOfMeasure, (Object)billingPlanItem.unitOfMeasure);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.itemNumber, this.name, this.type, this.function, this.description, this.dateChargedThrough, this.currencyIsoCode, this.discountAmount, this.dateEffectiveStart, this.dateEffectiveEnd, this.overagePrice, this.price, this.quantity, this.unitOfMeasure});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillingPlanItem {\n");
        sb.append("    itemNumber: ").append(this.toIndentedString(this.itemNumber)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    function: ").append(this.toIndentedString(this.function)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dateChargedThrough: ").append(this.toIndentedString(this.dateChargedThrough)).append("\n");
        sb.append("    currencyIsoCode: ").append(this.toIndentedString(this.currencyIsoCode)).append("\n");
        sb.append("    discountAmount: ").append(this.toIndentedString(this.discountAmount)).append("\n");
        sb.append("    dateEffectiveStart: ").append(this.toIndentedString(this.dateEffectiveStart)).append("\n");
        sb.append("    dateEffectiveEnd: ").append(this.toIndentedString(this.dateEffectiveEnd)).append("\n");
        sb.append("    overagePrice: ").append(this.toIndentedString(this.overagePrice)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString((Object)this.unitOfMeasure)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=UnitOfMeasureEnumDeserializer.class)
    public static enum UnitOfMeasureEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CALL("Call"),
        CHARACTER("Character"),
        CONVERSATION("Conversation"),
        COURSE("Course"),
        DAY("Day"),
        EACH("Each"),
        EMPLOYEE("Employee"),
        ENGAGEMENT("Engagement"),
        EVENT("Event"),
        EXAM("Exam"),
        GB("GB"),
        HOUR("Hour"),
        INSTANCE("Instance"),
        INTERACTION("Interaction"),
        INVOCATION("Invocation"),
        MESSAGE("Message"),
        MILLIONCHARACTERS("MillionCharacters"),
        MINUTE("Minute"),
        PERSON("Person"),
        PHONENUMBER("PhoneNumber"),
        PORT("Port"),
        SEGMENT("Segment"),
        SESSION("Session"),
        STREAM("Stream"),
        TOKEN("Token"),
        TRANSACTION("Transaction"),
        TURN("Turn"),
        UNIT("Unit"),
        USER("User");

        private String value;

        private UnitOfMeasureEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static UnitOfMeasureEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (UnitOfMeasureEnum value : UnitOfMeasureEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return UnitOfMeasureEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class UnitOfMeasureEnumDeserializer
    extends StdDeserializer<UnitOfMeasureEnum> {
        public UnitOfMeasureEnumDeserializer() {
            super(UnitOfMeasureEnumDeserializer.class);
        }

        public UnitOfMeasureEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return UnitOfMeasureEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

