/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AnalyticsEvaluation;
import com.mypurecloud.sdk.v2.model.AnalyticsParticipant;
import com.mypurecloud.sdk.v2.model.AnalyticsResolution;
import com.mypurecloud.sdk.v2.model.AnalyticsSurvey;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class AnalyticsConversation
implements Serializable {
    private Date conferenceStart = null;
    private Date conversationEnd = null;
    private String conversationId = null;
    private ConversationInitiatorEnum conversationInitiator = null;
    private Date conversationStart = null;
    private Boolean customerParticipation = null;
    private List<String> divisionIds = null;
    private String externalTag = null;
    private List<String> knowledgeBaseIds = null;
    private Double mediaStatsMinConversationMos = null;
    private Double mediaStatsMinConversationRFactor = null;
    private OriginatingDirectionEnum originatingDirection = null;
    private Boolean originatingSocialMediaPublic = null;
    private Boolean selfServed = null;
    private List<AnalyticsEvaluation> evaluations = null;
    private List<AnalyticsSurvey> surveys = null;
    private List<AnalyticsResolution> resolutions = null;
    private List<AnalyticsParticipant> participants = null;

    public AnalyticsConversation() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.divisionIds = new ArrayList<String>();
            this.knowledgeBaseIds = new ArrayList<String>();
            this.evaluations = new ArrayList<AnalyticsEvaluation>();
            this.surveys = new ArrayList<AnalyticsSurvey>();
            this.resolutions = new ArrayList<AnalyticsResolution>();
            this.participants = new ArrayList<AnalyticsParticipant>();
        }
    }

    public AnalyticsConversation conferenceStart(Date conferenceStart) {
        this.conferenceStart = conferenceStart;
        return this;
    }

    @ApiModelProperty(example="null", value="The start time of a conference call. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="conferenceStart")
    public Date getConferenceStart() {
        return this.conferenceStart;
    }

    public void setConferenceStart(Date conferenceStart) {
        this.conferenceStart = conferenceStart;
    }

    public AnalyticsConversation conversationEnd(Date conversationEnd) {
        this.conversationEnd = conversationEnd;
        return this;
    }

    @ApiModelProperty(example="null", value="The end time of a conversation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="conversationEnd")
    public Date getConversationEnd() {
        return this.conversationEnd;
    }

    public void setConversationEnd(Date conversationEnd) {
        this.conversationEnd = conversationEnd;
    }

    public AnalyticsConversation conversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique identifier for the conversation")
    @JsonProperty(value="conversationId")
    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public AnalyticsConversation conversationInitiator(ConversationInitiatorEnum conversationInitiator) {
        this.conversationInitiator = conversationInitiator;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates the participant purpose of the participant initiating a message conversation")
    @JsonProperty(value="conversationInitiator")
    public ConversationInitiatorEnum getConversationInitiator() {
        return this.conversationInitiator;
    }

    public void setConversationInitiator(ConversationInitiatorEnum conversationInitiator) {
        this.conversationInitiator = conversationInitiator;
    }

    public AnalyticsConversation conversationStart(Date conversationStart) {
        this.conversationStart = conversationStart;
        return this;
    }

    @ApiModelProperty(example="null", value="The start time of a conversation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="conversationStart")
    public Date getConversationStart() {
        return this.conversationStart;
    }

    public void setConversationStart(Date conversationStart) {
        this.conversationStart = conversationStart;
    }

    public AnalyticsConversation customerParticipation(Boolean customerParticipation) {
        this.customerParticipation = customerParticipation;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates a messaging conversation in which the customer participated by sending at least one message")
    @JsonProperty(value="customerParticipation")
    public Boolean getCustomerParticipation() {
        return this.customerParticipation;
    }

    public void setCustomerParticipation(Boolean customerParticipation) {
        this.customerParticipation = customerParticipation;
    }

    public AnalyticsConversation divisionIds(List<String> divisionIds) {
        this.divisionIds = divisionIds;
        return this;
    }

    @ApiModelProperty(example="null", value="Identifier(s) of division(s) associated with a conversation")
    @JsonProperty(value="divisionIds")
    public List<String> getDivisionIds() {
        return this.divisionIds;
    }

    public void setDivisionIds(List<String> divisionIds) {
        this.divisionIds = divisionIds;
    }

    public AnalyticsConversation externalTag(String externalTag) {
        this.externalTag = externalTag;
        return this;
    }

    @ApiModelProperty(example="null", value="External tag for the conversation")
    @JsonProperty(value="externalTag")
    public String getExternalTag() {
        return this.externalTag;
    }

    public void setExternalTag(String externalTag) {
        this.externalTag = externalTag;
    }

    public AnalyticsConversation knowledgeBaseIds(List<String> knowledgeBaseIds) {
        this.knowledgeBaseIds = knowledgeBaseIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The unique identifier(s) of the knowledge base(s) used")
    @JsonProperty(value="knowledgeBaseIds")
    public List<String> getKnowledgeBaseIds() {
        return this.knowledgeBaseIds;
    }

    public void setKnowledgeBaseIds(List<String> knowledgeBaseIds) {
        this.knowledgeBaseIds = knowledgeBaseIds;
    }

    public AnalyticsConversation mediaStatsMinConversationMos(Double mediaStatsMinConversationMos) {
        this.mediaStatsMinConversationMos = mediaStatsMinConversationMos;
        return this;
    }

    @ApiModelProperty(example="null", value="The lowest estimated average MOS among all the audio streams belonging to this conversation")
    @JsonProperty(value="mediaStatsMinConversationMos")
    public Double getMediaStatsMinConversationMos() {
        return this.mediaStatsMinConversationMos;
    }

    public void setMediaStatsMinConversationMos(Double mediaStatsMinConversationMos) {
        this.mediaStatsMinConversationMos = mediaStatsMinConversationMos;
    }

    public AnalyticsConversation mediaStatsMinConversationRFactor(Double mediaStatsMinConversationRFactor) {
        this.mediaStatsMinConversationRFactor = mediaStatsMinConversationRFactor;
        return this;
    }

    @ApiModelProperty(example="null", value="The lowest R-factor value among all of the audio streams belonging to this conversation")
    @JsonProperty(value="mediaStatsMinConversationRFactor")
    public Double getMediaStatsMinConversationRFactor() {
        return this.mediaStatsMinConversationRFactor;
    }

    public void setMediaStatsMinConversationRFactor(Double mediaStatsMinConversationRFactor) {
        this.mediaStatsMinConversationRFactor = mediaStatsMinConversationRFactor;
    }

    public AnalyticsConversation originatingDirection(OriginatingDirectionEnum originatingDirection) {
        this.originatingDirection = originatingDirection;
        return this;
    }

    @ApiModelProperty(example="null", value="The original direction of the conversation")
    @JsonProperty(value="originatingDirection")
    public OriginatingDirectionEnum getOriginatingDirection() {
        return this.originatingDirection;
    }

    public void setOriginatingDirection(OriginatingDirectionEnum originatingDirection) {
        this.originatingDirection = originatingDirection;
    }

    public AnalyticsConversation originatingSocialMediaPublic(Boolean originatingSocialMediaPublic) {
        this.originatingSocialMediaPublic = originatingSocialMediaPublic;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates that the conversation originated from a public message on social media")
    @JsonProperty(value="originatingSocialMediaPublic")
    public Boolean getOriginatingSocialMediaPublic() {
        return this.originatingSocialMediaPublic;
    }

    public void setOriginatingSocialMediaPublic(Boolean originatingSocialMediaPublic) {
        this.originatingSocialMediaPublic = originatingSocialMediaPublic;
    }

    public AnalyticsConversation selfServed(Boolean selfServed) {
        this.selfServed = selfServed;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether all flow sessions were self serviced")
    @JsonProperty(value="selfServed")
    public Boolean getSelfServed() {
        return this.selfServed;
    }

    public void setSelfServed(Boolean selfServed) {
        this.selfServed = selfServed;
    }

    public AnalyticsConversation evaluations(List<AnalyticsEvaluation> evaluations) {
        this.evaluations = evaluations;
        return this;
    }

    @ApiModelProperty(example="null", value="Evaluations associated with this conversation")
    @JsonProperty(value="evaluations")
    public List<AnalyticsEvaluation> getEvaluations() {
        return this.evaluations;
    }

    public void setEvaluations(List<AnalyticsEvaluation> evaluations) {
        this.evaluations = evaluations;
    }

    public AnalyticsConversation surveys(List<AnalyticsSurvey> surveys) {
        this.surveys = surveys;
        return this;
    }

    @ApiModelProperty(example="null", value="Surveys associated with this conversation")
    @JsonProperty(value="surveys")
    public List<AnalyticsSurvey> getSurveys() {
        return this.surveys;
    }

    public void setSurveys(List<AnalyticsSurvey> surveys) {
        this.surveys = surveys;
    }

    public AnalyticsConversation resolutions(List<AnalyticsResolution> resolutions) {
        this.resolutions = resolutions;
        return this;
    }

    @ApiModelProperty(example="null", value="Resolutions associated with this conversation")
    @JsonProperty(value="resolutions")
    public List<AnalyticsResolution> getResolutions() {
        return this.resolutions;
    }

    public void setResolutions(List<AnalyticsResolution> resolutions) {
        this.resolutions = resolutions;
    }

    public AnalyticsConversation participants(List<AnalyticsParticipant> participants) {
        this.participants = participants;
        return this;
    }

    @ApiModelProperty(example="null", value="Participants in the conversation")
    @JsonProperty(value="participants")
    public List<AnalyticsParticipant> getParticipants() {
        return this.participants;
    }

    public void setParticipants(List<AnalyticsParticipant> participants) {
        this.participants = participants;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyticsConversation analyticsConversation = (AnalyticsConversation)o;
        return Objects.equals(this.conferenceStart, analyticsConversation.conferenceStart) && Objects.equals(this.conversationEnd, analyticsConversation.conversationEnd) && Objects.equals(this.conversationId, analyticsConversation.conversationId) && Objects.equals((Object)this.conversationInitiator, (Object)analyticsConversation.conversationInitiator) && Objects.equals(this.conversationStart, analyticsConversation.conversationStart) && Objects.equals(this.customerParticipation, analyticsConversation.customerParticipation) && Objects.equals(this.divisionIds, analyticsConversation.divisionIds) && Objects.equals(this.externalTag, analyticsConversation.externalTag) && Objects.equals(this.knowledgeBaseIds, analyticsConversation.knowledgeBaseIds) && Objects.equals(this.mediaStatsMinConversationMos, analyticsConversation.mediaStatsMinConversationMos) && Objects.equals(this.mediaStatsMinConversationRFactor, analyticsConversation.mediaStatsMinConversationRFactor) && Objects.equals((Object)this.originatingDirection, (Object)analyticsConversation.originatingDirection) && Objects.equals(this.originatingSocialMediaPublic, analyticsConversation.originatingSocialMediaPublic) && Objects.equals(this.selfServed, analyticsConversation.selfServed) && Objects.equals(this.evaluations, analyticsConversation.evaluations) && Objects.equals(this.surveys, analyticsConversation.surveys) && Objects.equals(this.resolutions, analyticsConversation.resolutions) && Objects.equals(this.participants, analyticsConversation.participants);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.conferenceStart, this.conversationEnd, this.conversationId, this.conversationInitiator, this.conversationStart, this.customerParticipation, this.divisionIds, this.externalTag, this.knowledgeBaseIds, this.mediaStatsMinConversationMos, this.mediaStatsMinConversationRFactor, this.originatingDirection, this.originatingSocialMediaPublic, this.selfServed, this.evaluations, this.surveys, this.resolutions, this.participants});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnalyticsConversation {\n");
        sb.append("    conferenceStart: ").append(this.toIndentedString(this.conferenceStart)).append("\n");
        sb.append("    conversationEnd: ").append(this.toIndentedString(this.conversationEnd)).append("\n");
        sb.append("    conversationId: ").append(this.toIndentedString(this.conversationId)).append("\n");
        sb.append("    conversationInitiator: ").append(this.toIndentedString((Object)this.conversationInitiator)).append("\n");
        sb.append("    conversationStart: ").append(this.toIndentedString(this.conversationStart)).append("\n");
        sb.append("    customerParticipation: ").append(this.toIndentedString(this.customerParticipation)).append("\n");
        sb.append("    divisionIds: ").append(this.toIndentedString(this.divisionIds)).append("\n");
        sb.append("    externalTag: ").append(this.toIndentedString(this.externalTag)).append("\n");
        sb.append("    knowledgeBaseIds: ").append(this.toIndentedString(this.knowledgeBaseIds)).append("\n");
        sb.append("    mediaStatsMinConversationMos: ").append(this.toIndentedString(this.mediaStatsMinConversationMos)).append("\n");
        sb.append("    mediaStatsMinConversationRFactor: ").append(this.toIndentedString(this.mediaStatsMinConversationRFactor)).append("\n");
        sb.append("    originatingDirection: ").append(this.toIndentedString((Object)this.originatingDirection)).append("\n");
        sb.append("    originatingSocialMediaPublic: ").append(this.toIndentedString(this.originatingSocialMediaPublic)).append("\n");
        sb.append("    selfServed: ").append(this.toIndentedString(this.selfServed)).append("\n");
        sb.append("    evaluations: ").append(this.toIndentedString(this.evaluations)).append("\n");
        sb.append("    surveys: ").append(this.toIndentedString(this.surveys)).append("\n");
        sb.append("    resolutions: ").append(this.toIndentedString(this.resolutions)).append("\n");
        sb.append("    participants: ").append(this.toIndentedString(this.participants)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ConversationInitiatorEnumDeserializer.class)
    public static enum ConversationInitiatorEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACD("acd"),
        AGENT("agent"),
        API("api"),
        BOTFLOW("botflow"),
        CAMPAIGN("campaign"),
        CUSTOMER("customer"),
        DIALER("dialer"),
        EXTERNAL("external"),
        FAX("fax"),
        GROUP("group"),
        INBOUND("inbound"),
        IVR("ivr"),
        MANUAL("manual"),
        OUTBOUND("outbound"),
        STATION("station"),
        USER("user"),
        VOICEMAIL("voicemail"),
        VOICESURVEYFLOW("voicesurveyflow"),
        WORKFLOW("workflow");

        private String value;

        private ConversationInitiatorEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ConversationInitiatorEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ConversationInitiatorEnum value : ConversationInitiatorEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ConversationInitiatorEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=OriginatingDirectionEnumDeserializer.class)
    public static enum OriginatingDirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INBOUND("inbound"),
        OUTBOUND("outbound");

        private String value;

        private OriginatingDirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OriginatingDirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OriginatingDirectionEnum value : OriginatingDirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OriginatingDirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class OriginatingDirectionEnumDeserializer
    extends StdDeserializer<OriginatingDirectionEnum> {
        public OriginatingDirectionEnumDeserializer() {
            super(OriginatingDirectionEnumDeserializer.class);
        }

        public OriginatingDirectionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OriginatingDirectionEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class ConversationInitiatorEnumDeserializer
    extends StdDeserializer<ConversationInitiatorEnum> {
        public ConversationInitiatorEnumDeserializer() {
            super(ConversationInitiatorEnumDeserializer.class);
        }

        public ConversationInitiatorEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ConversationInitiatorEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

