/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.UserReference;
import com.mypurecloud.sdk.v2.model.WorkPlanReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AdminAgentWorkPlanBiddingPreference
implements Serializable {
    private UserReference agent = null;
    private Boolean submitted = null;
    private WorkPlanReference assignedWorkPlan = null;
    private WorkPlanReference overriddenWorkPlan = null;
    private OverrideReasonEnum overrideReason = null;
    private List<Integer> priorities = null;

    public AdminAgentWorkPlanBiddingPreference() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.priorities = new ArrayList<Integer>();
        }
    }

    public AdminAgentWorkPlanBiddingPreference agent(UserReference agent) {
        this.agent = agent;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The agent to whom this work plan bidding preference applies")
    @JsonProperty(value="agent")
    public UserReference getAgent() {
        return this.agent;
    }

    public void setAgent(UserReference agent) {
        this.agent = agent;
    }

    public AdminAgentWorkPlanBiddingPreference submitted(Boolean submitted) {
        this.submitted = submitted;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether the preference is submitted")
    @JsonProperty(value="submitted")
    public Boolean getSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(Boolean submitted) {
        this.submitted = submitted;
    }

    public AdminAgentWorkPlanBiddingPreference assignedWorkPlan(WorkPlanReference assignedWorkPlan) {
        this.assignedWorkPlan = assignedWorkPlan;
        return this;
    }

    @ApiModelProperty(example="null", value="The work plan assigned to the agent by the bid process")
    @JsonProperty(value="assignedWorkPlan")
    public WorkPlanReference getAssignedWorkPlan() {
        return this.assignedWorkPlan;
    }

    public void setAssignedWorkPlan(WorkPlanReference assignedWorkPlan) {
        this.assignedWorkPlan = assignedWorkPlan;
    }

    public AdminAgentWorkPlanBiddingPreference overriddenWorkPlan(WorkPlanReference overriddenWorkPlan) {
        this.overriddenWorkPlan = overriddenWorkPlan;
        return this;
    }

    @ApiModelProperty(example="null", value="The work plan that overrides the assigned work plan for the agent")
    @JsonProperty(value="overriddenWorkPlan")
    public WorkPlanReference getOverriddenWorkPlan() {
        return this.overriddenWorkPlan;
    }

    public void setOverriddenWorkPlan(WorkPlanReference overriddenWorkPlan) {
        this.overriddenWorkPlan = overriddenWorkPlan;
    }

    public AdminAgentWorkPlanBiddingPreference overrideReason(OverrideReasonEnum overrideReason) {
        this.overrideReason = overrideReason;
        return this;
    }

    @ApiModelProperty(example="null", value="The reason why the assigned work plan has been overridden. This must be null without an override work plan")
    @JsonProperty(value="overrideReason")
    public OverrideReasonEnum getOverrideReason() {
        return this.overrideReason;
    }

    public void setOverrideReason(OverrideReasonEnum overrideReason) {
        this.overrideReason = overrideReason;
    }

    public AdminAgentWorkPlanBiddingPreference priorities(List<Integer> priorities) {
        this.priorities = priorities;
        return this;
    }

    @ApiModelProperty(example="null", value="The agent priorities for the list of work plans. The index of the priorities should match with the list of work plans that belong to bid group. It contains null if priority is not set for the work plan")
    @JsonProperty(value="priorities")
    public List<Integer> getPriorities() {
        return this.priorities;
    }

    public void setPriorities(List<Integer> priorities) {
        this.priorities = priorities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdminAgentWorkPlanBiddingPreference adminAgentWorkPlanBiddingPreference = (AdminAgentWorkPlanBiddingPreference)o;
        return Objects.equals(this.agent, adminAgentWorkPlanBiddingPreference.agent) && Objects.equals(this.submitted, adminAgentWorkPlanBiddingPreference.submitted) && Objects.equals(this.assignedWorkPlan, adminAgentWorkPlanBiddingPreference.assignedWorkPlan) && Objects.equals(this.overriddenWorkPlan, adminAgentWorkPlanBiddingPreference.overriddenWorkPlan) && Objects.equals((Object)this.overrideReason, (Object)adminAgentWorkPlanBiddingPreference.overrideReason) && Objects.equals(this.priorities, adminAgentWorkPlanBiddingPreference.priorities);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.agent, this.submitted, this.assignedWorkPlan, this.overriddenWorkPlan, this.overrideReason, this.priorities});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdminAgentWorkPlanBiddingPreference {\n");
        sb.append("    agent: ").append(this.toIndentedString(this.agent)).append("\n");
        sb.append("    submitted: ").append(this.toIndentedString(this.submitted)).append("\n");
        sb.append("    assignedWorkPlan: ").append(this.toIndentedString(this.assignedWorkPlan)).append("\n");
        sb.append("    overriddenWorkPlan: ").append(this.toIndentedString(this.overriddenWorkPlan)).append("\n");
        sb.append("    overrideReason: ").append(this.toIndentedString((Object)this.overrideReason)).append("\n");
        sb.append("    priorities: ").append(this.toIndentedString(this.priorities)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=OverrideReasonEnumDeserializer.class)
    public static enum OverrideReasonEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNABLETOBID("UnableToBid"),
        CHANGEOFCIRCUMSTANCE("ChangeOfCircumstance"),
        NEWHIRE("NewHire"),
        EMPLOYEEMOVE("EmployeeMove");

        private String value;

        private OverrideReasonEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OverrideReasonEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OverrideReasonEnum value : OverrideReasonEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OverrideReasonEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class OverrideReasonEnumDeserializer
    extends StdDeserializer<OverrideReasonEnum> {
        public OverrideReasonEnumDeserializer() {
            super(OverrideReasonEnumDeserializer.class);
        }

        public OverrideReasonEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OverrideReasonEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

