/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetUsersExternalidAuthorityNameExternalKeyRequest {
    private String authorityName;
    private String externalKey;
    private List<String> expand;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getAuthorityName() {
        return this.authorityName;
    }

    public void setAuthorityName(String authorityName) {
        this.authorityName = authorityName;
    }

    public GetUsersExternalidAuthorityNameExternalKeyRequest withAuthorityName(String authorityName) {
        this.setAuthorityName(authorityName);
        return this;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public void setExternalKey(String externalKey) {
        this.externalKey = externalKey;
    }

    public GetUsersExternalidAuthorityNameExternalKeyRequest withExternalKey(String externalKey) {
        this.setExternalKey(externalKey);
        return this;
    }

    public List<String> getExpand() {
        return this.expand;
    }

    public void setExpand(List<String> expand) {
        this.expand = expand;
    }

    public GetUsersExternalidAuthorityNameExternalKeyRequest withExpand(List<String> expand) {
        this.setExpand(expand);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetUsersExternalidAuthorityNameExternalKeyRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.authorityName == null) {
            throw new IllegalStateException("Missing the required parameter 'authorityName' when building request for GetUsersExternalidAuthorityNameExternalKeyRequest.");
        }
        if (this.externalKey == null) {
            throw new IllegalStateException("Missing the required parameter 'externalKey' when building request for GetUsersExternalidAuthorityNameExternalKeyRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/users/externalid/{authorityName}/{externalKey}").withPathParameter("authorityName", this.authorityName).withPathParameter("externalKey", this.externalKey).withQueryParameters("expand", "multi", this.expand).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String authorityName, String externalKey) {
        return new Builder().withRequiredParams(authorityName, externalKey);
    }

    public static class Builder {
        private final GetUsersExternalidAuthorityNameExternalKeyRequest request = new GetUsersExternalidAuthorityNameExternalKeyRequest();

        private Builder() {
        }

        public Builder withAuthorityName(String authorityName) {
            this.request.setAuthorityName(authorityName);
            return this;
        }

        public Builder withExternalKey(String externalKey) {
            this.request.setExternalKey(externalKey);
            return this;
        }

        public Builder withExpand(List<String> expand) {
            this.request.setExpand(expand);
            return this;
        }

        public Builder withExpandEnumValues(List<expandValues> expand) {
            ArrayList<String> stringList = new ArrayList<String>();
            for (expandValues e : expand) {
                stringList.add(e.toString());
            }
            this.request.setExpand(stringList);
            return this;
        }

        public Builder withRequiredParams(String authorityName, String externalKey) {
            this.request.setAuthorityName(authorityName);
            this.request.setExternalKey(externalKey);
            return this;
        }

        public GetUsersExternalidAuthorityNameExternalKeyRequest build() {
            if (this.request.authorityName == null) {
                throw new IllegalStateException("Missing the required parameter 'authorityName' when building request for GetUsersExternalidAuthorityNameExternalKeyRequest.");
            }
            if (this.request.externalKey == null) {
                throw new IllegalStateException("Missing the required parameter 'externalKey' when building request for GetUsersExternalidAuthorityNameExternalKeyRequest.");
            }
            return this.request;
        }
    }

    public static enum expandValues {
        ROUTINGSTATUS("routingStatus"),
        PRESENCE("presence"),
        INTEGRATIONPRESENCE("integrationPresence"),
        CONVERSATIONSUMMARY("conversationSummary"),
        OUTOFOFFICE("outOfOffice"),
        GEOLOCATION("geolocation"),
        STATION("station"),
        AUTHORIZATION("authorization"),
        LASTTOKENISSUED("lasttokenissued"),
        AUTHORIZATION_UNUSEDROLES("authorization.unusedRoles"),
        TEAM("team"),
        WORKPLANBIDRANKS("workPlanBidRanks"),
        EXTERNALCONTACTSSETTINGS("externalContactsSettings"),
        PROFILESKILLS("profileSkills"),
        CERTIFICATIONS("certifications"),
        LOCATIONS("locations"),
        GROUPS("groups"),
        SKILLS("skills"),
        LANGUAGES("languages"),
        LANGUAGEPREFERENCE("languagePreference"),
        EMPLOYERINFO("employerInfo"),
        BIOGRAPHY("biography"),
        DATELASTLOGIN("dateLastLogin"),
        DATEWELCOMESENT("dateWelcomeSent");

        private String value;

        private expandValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static expandValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (expandValues value : expandValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return expandValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

