/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetRoutingQueueMediatypeEstimatedwaittimeRequest {
    private String queueId;
    private String mediaType;
    private String labelId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public GetRoutingQueueMediatypeEstimatedwaittimeRequest withQueueId(String queueId) {
        this.setQueueId(queueId);
        return this;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public GetRoutingQueueMediatypeEstimatedwaittimeRequest withMediaType(String mediaType) {
        this.setMediaType(mediaType);
        return this;
    }

    public String getLabelId() {
        return this.labelId;
    }

    public void setLabelId(String labelId) {
        this.labelId = labelId;
    }

    public GetRoutingQueueMediatypeEstimatedwaittimeRequest withLabelId(String labelId) {
        this.setLabelId(labelId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetRoutingQueueMediatypeEstimatedwaittimeRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.queueId == null) {
            throw new IllegalStateException("Missing the required parameter 'queueId' when building request for GetRoutingQueueMediatypeEstimatedwaittimeRequest.");
        }
        if (this.mediaType == null) {
            throw new IllegalStateException("Missing the required parameter 'mediaType' when building request for GetRoutingQueueMediatypeEstimatedwaittimeRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/routing/queues/{queueId}/mediatypes/{mediaType}/estimatedwaittime").withPathParameter("queueId", this.queueId).withPathParameter("mediaType", this.mediaType).withQueryParameters("labelId", "", this.labelId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String queueId, String mediaType) {
        return new Builder().withRequiredParams(queueId, mediaType);
    }

    public static class Builder {
        private final GetRoutingQueueMediatypeEstimatedwaittimeRequest request = new GetRoutingQueueMediatypeEstimatedwaittimeRequest();

        private Builder() {
        }

        public Builder withQueueId(String queueId) {
            this.request.setQueueId(queueId);
            return this;
        }

        public Builder withMediaType(String mediaType) {
            this.request.setMediaType(mediaType);
            return this;
        }

        public Builder withMediaType(mediaTypeValues mediaType) {
            this.request.setMediaType(mediaType.toString());
            return this;
        }

        public Builder withLabelId(String labelId) {
            this.request.setLabelId(labelId);
            return this;
        }

        public Builder withRequiredParams(String queueId, String mediaType) {
            this.request.setQueueId(queueId);
            this.request.setMediaType(mediaType);
            return this;
        }

        public GetRoutingQueueMediatypeEstimatedwaittimeRequest build() {
            if (this.request.queueId == null) {
                throw new IllegalStateException("Missing the required parameter 'queueId' when building request for GetRoutingQueueMediatypeEstimatedwaittimeRequest.");
            }
            if (this.request.mediaType == null) {
                throw new IllegalStateException("Missing the required parameter 'mediaType' when building request for GetRoutingQueueMediatypeEstimatedwaittimeRequest.");
            }
            return this.request;
        }
    }

    public static enum mediaTypeValues {
        ALL("all"),
        CALL("call"),
        CHAT("chat"),
        CALLBACK("callback"),
        EMAIL("email"),
        VIDEOCOMM("videoComm"),
        MESSAGE("message");

        private String value;

        private mediaTypeValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static mediaTypeValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (mediaTypeValues value : mediaTypeValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return mediaTypeValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

