/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetArchitectGrammarLanguageRequest {
    private String grammarId;
    private String languageCode;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getGrammarId() {
        return this.grammarId;
    }

    public void setGrammarId(String grammarId) {
        this.grammarId = grammarId;
    }

    public GetArchitectGrammarLanguageRequest withGrammarId(String grammarId) {
        this.setGrammarId(grammarId);
        return this;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public GetArchitectGrammarLanguageRequest withLanguageCode(String languageCode) {
        this.setLanguageCode(languageCode);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetArchitectGrammarLanguageRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.grammarId == null) {
            throw new IllegalStateException("Missing the required parameter 'grammarId' when building request for GetArchitectGrammarLanguageRequest.");
        }
        if (this.languageCode == null) {
            throw new IllegalStateException("Missing the required parameter 'languageCode' when building request for GetArchitectGrammarLanguageRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/architect/grammars/{grammarId}/languages/{languageCode}").withPathParameter("grammarId", this.grammarId).withPathParameter("languageCode", this.languageCode).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String grammarId, String languageCode) {
        return new Builder().withRequiredParams(grammarId, languageCode);
    }

    public static class Builder {
        private final GetArchitectGrammarLanguageRequest request = new GetArchitectGrammarLanguageRequest();

        private Builder() {
        }

        public Builder withGrammarId(String grammarId) {
            this.request.setGrammarId(grammarId);
            return this;
        }

        public Builder withLanguageCode(String languageCode) {
            this.request.setLanguageCode(languageCode);
            return this;
        }

        public Builder withRequiredParams(String grammarId, String languageCode) {
            this.request.setGrammarId(grammarId);
            this.request.setLanguageCode(languageCode);
            return this;
        }

        public GetArchitectGrammarLanguageRequest build() {
            if (this.request.grammarId == null) {
                throw new IllegalStateException("Missing the required parameter 'grammarId' when building request for GetArchitectGrammarLanguageRequest.");
            }
            if (this.request.languageCode == null) {
                throw new IllegalStateException("Missing the required parameter 'languageCode' when building request for GetArchitectGrammarLanguageRequest.");
            }
            return this.request;
        }
    }
}

