/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetSearchRequest;
import com.mypurecloud.sdk.v2.api.request.GetSearchSuggestRequest;
import com.mypurecloud.sdk.v2.api.request.PostSearchRequest;
import com.mypurecloud.sdk.v2.api.request.PostSearchSuggestRequest;
import com.mypurecloud.sdk.v2.model.JsonNodeSearchResponse;
import com.mypurecloud.sdk.v2.model.SearchRequest;
import com.mypurecloud.sdk.v2.model.SuggestSearchRequest;
import java.io.IOException;
import java.util.List;

public class SuggestApi {
    private final ApiClient pcapiClient;

    public SuggestApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SuggestApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public JsonNodeSearchResponse getSearch(String q64, List<String> expand, Boolean profile) throws IOException, ApiException {
        return this.getSearch(this.createGetSearchRequest(q64, expand, profile));
    }

    public ApiResponse<JsonNodeSearchResponse> getSearchWithHttpInfo(String q64, List<String> expand, Boolean profile) throws IOException {
        return this.getSearch(this.createGetSearchRequest(q64, expand, profile).withHttpInfo());
    }

    private GetSearchRequest createGetSearchRequest(String q64, List<String> expand, Boolean profile) {
        return GetSearchRequest.builder().withQ64(q64).withExpand(expand).withProfile(profile).build();
    }

    public JsonNodeSearchResponse getSearch(GetSearchRequest request) throws IOException, ApiException {
        try {
            ApiResponse<JsonNodeSearchResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<JsonNodeSearchResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<JsonNodeSearchResponse> getSearch(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<JsonNodeSearchResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public JsonNodeSearchResponse getSearchSuggest(String q64, List<String> expand, Boolean profile) throws IOException, ApiException {
        return this.getSearchSuggest(this.createGetSearchSuggestRequest(q64, expand, profile));
    }

    public ApiResponse<JsonNodeSearchResponse> getSearchSuggestWithHttpInfo(String q64, List<String> expand, Boolean profile) throws IOException {
        return this.getSearchSuggest(this.createGetSearchSuggestRequest(q64, expand, profile).withHttpInfo());
    }

    private GetSearchSuggestRequest createGetSearchSuggestRequest(String q64, List<String> expand, Boolean profile) {
        return GetSearchSuggestRequest.builder().withQ64(q64).withExpand(expand).withProfile(profile).build();
    }

    public JsonNodeSearchResponse getSearchSuggest(GetSearchSuggestRequest request) throws IOException, ApiException {
        try {
            ApiResponse<JsonNodeSearchResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<JsonNodeSearchResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<JsonNodeSearchResponse> getSearchSuggest(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<JsonNodeSearchResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public JsonNodeSearchResponse postSearch(SearchRequest body, Boolean profile) throws IOException, ApiException {
        return this.postSearch(this.createPostSearchRequest(body, profile));
    }

    public ApiResponse<JsonNodeSearchResponse> postSearchWithHttpInfo(SearchRequest body, Boolean profile) throws IOException {
        return this.postSearch(this.createPostSearchRequest(body, profile).withHttpInfo());
    }

    private PostSearchRequest createPostSearchRequest(SearchRequest body, Boolean profile) {
        return PostSearchRequest.builder().withBody(body).withProfile(profile).build();
    }

    public JsonNodeSearchResponse postSearch(PostSearchRequest request) throws IOException, ApiException {
        try {
            ApiResponse<JsonNodeSearchResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<JsonNodeSearchResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<JsonNodeSearchResponse> postSearch(ApiRequest<SearchRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<JsonNodeSearchResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public JsonNodeSearchResponse postSearchSuggest(SuggestSearchRequest body, Boolean profile) throws IOException, ApiException {
        return this.postSearchSuggest(this.createPostSearchSuggestRequest(body, profile));
    }

    public ApiResponse<JsonNodeSearchResponse> postSearchSuggestWithHttpInfo(SuggestSearchRequest body, Boolean profile) throws IOException {
        return this.postSearchSuggest(this.createPostSearchSuggestRequest(body, profile).withHttpInfo());
    }

    private PostSearchSuggestRequest createPostSearchSuggestRequest(SuggestSearchRequest body, Boolean profile) {
        return PostSearchSuggestRequest.builder().withBody(body).withProfile(profile).build();
    }

    public JsonNodeSearchResponse postSearchSuggest(PostSearchSuggestRequest request) throws IOException, ApiException {
        try {
            ApiResponse<JsonNodeSearchResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<JsonNodeSearchResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<JsonNodeSearchResponse> postSearchSuggest(ApiRequest<SuggestSearchRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<JsonNodeSearchResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

