/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Defines a link between an External Identifier and Authority pair to a Entity Type and Entity Identifier pair. Represents the two way, one to one mapping of an External Authority or System of Record's identifier to a PureCloud entity. e.g. (ExternalId='05001',Authority='XyzCRM') to (entityType=user,entityId='8eb03b33-3acb-4bc1-a244-50b9b9f19495')")
public class UserExternalIdentifier
implements Serializable {
    private String authorityName = null;
    private String externalKey = null;
    private String selfUri = null;

    public UserExternalIdentifier() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public UserExternalIdentifier authorityName(String authorityName) {
        this.authorityName = authorityName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Authority or System of Record which owns the External Identifier")
    @JsonProperty(value="authorityName")
    public String getAuthorityName() {
        return this.authorityName;
    }

    public void setAuthorityName(String authorityName) {
        this.authorityName = authorityName;
    }

    public UserExternalIdentifier externalKey(String externalKey) {
        this.externalKey = externalKey;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="External Key")
    @JsonProperty(value="externalKey")
    public String getExternalKey() {
        return this.externalKey;
    }

    public void setExternalKey(String externalKey) {
        this.externalKey = externalKey;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserExternalIdentifier userExternalIdentifier = (UserExternalIdentifier)o;
        return Objects.equals(this.authorityName, userExternalIdentifier.authorityName) && Objects.equals(this.externalKey, userExternalIdentifier.externalKey) && Objects.equals(this.selfUri, userExternalIdentifier.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.authorityName, this.externalKey, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserExternalIdentifier {\n");
        sb.append("    authorityName: ").append(this.toIndentedString(this.authorityName)).append("\n");
        sb.append("    externalKey: ").append(this.toIndentedString(this.externalKey)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

