/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.GroupContact;
import com.mypurecloud.sdk.v2.model.Image;
import com.mypurecloud.sdk.v2.model.OrgUser;
import com.mypurecloud.sdk.v2.model.User;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class TrustGroup
implements Serializable {
    private String id = null;
    private String name = null;
    private String description = null;
    private Date dateModified = null;
    private Long memberCount = null;
    private StateEnum state = null;
    private Integer version = null;
    private TypeEnum type = null;
    private List<Image> images = null;
    private List<GroupContact> addresses = null;
    private Boolean rulesVisible = null;
    private VisibilityEnum visibility = null;
    private Boolean rolesEnabled = null;
    private Boolean includeOwners = null;
    private Boolean callsEnabled = null;
    private List<User> owners = null;
    private Date dateCreated = null;
    private OrgUser createdBy = null;

    public TrustGroup() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.images = new ArrayList<Image>();
            this.addresses = new ArrayList<GroupContact>();
            this.owners = new ArrayList<User>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public TrustGroup name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The group name.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TrustGroup description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(example="null", value="Last modified date/time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="Number of members.")
    @JsonProperty(value="memberCount")
    public Long getMemberCount() {
        return this.memberCount;
    }

    @ApiModelProperty(example="null", value="Active, inactive, or deleted state.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    @ApiModelProperty(example="null", value="Current version for this resource.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public TrustGroup type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Type of group.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public TrustGroup images(List<Image> images) {
        this.images = images;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="images")
    public List<Image> getImages() {
        return this.images;
    }

    public void setImages(List<Image> images) {
        this.images = images;
    }

    public TrustGroup addresses(List<GroupContact> addresses) {
        this.addresses = addresses;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="addresses")
    public List<GroupContact> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<GroupContact> addresses) {
        this.addresses = addresses;
    }

    public TrustGroup rulesVisible(Boolean rulesVisible) {
        this.rulesVisible = rulesVisible;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Are membership rules visible to the person requesting to view the group")
    @JsonProperty(value="rulesVisible")
    public Boolean getRulesVisible() {
        return this.rulesVisible;
    }

    public void setRulesVisible(Boolean rulesVisible) {
        this.rulesVisible = rulesVisible;
    }

    public TrustGroup visibility(VisibilityEnum visibility) {
        this.visibility = visibility;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Who can view this group")
    @JsonProperty(value="visibility")
    public VisibilityEnum getVisibility() {
        return this.visibility;
    }

    public void setVisibility(VisibilityEnum visibility) {
        this.visibility = visibility;
    }

    public TrustGroup rolesEnabled(Boolean rolesEnabled) {
        this.rolesEnabled = rolesEnabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Allow roles to be assigned to this group")
    @JsonProperty(value="rolesEnabled")
    public Boolean getRolesEnabled() {
        return this.rolesEnabled;
    }

    public void setRolesEnabled(Boolean rolesEnabled) {
        this.rolesEnabled = rolesEnabled;
    }

    public TrustGroup includeOwners(Boolean includeOwners) {
        this.includeOwners = includeOwners;
        return this;
    }

    @ApiModelProperty(example="null", value="Allow owners to be included as members of the group")
    @JsonProperty(value="includeOwners")
    public Boolean getIncludeOwners() {
        return this.includeOwners;
    }

    public void setIncludeOwners(Boolean includeOwners) {
        this.includeOwners = includeOwners;
    }

    public TrustGroup callsEnabled(Boolean callsEnabled) {
        this.callsEnabled = callsEnabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Allow calls to be placed to this group.")
    @JsonProperty(value="callsEnabled")
    public Boolean getCallsEnabled() {
        return this.callsEnabled;
    }

    public void setCallsEnabled(Boolean callsEnabled) {
        this.callsEnabled = callsEnabled;
    }

    public TrustGroup owners(List<User> owners) {
        this.owners = owners;
        return this;
    }

    @ApiModelProperty(example="null", value="Owners of the group")
    @JsonProperty(value="owners")
    public List<User> getOwners() {
        return this.owners;
    }

    public void setOwners(List<User> owners) {
        this.owners = owners;
    }

    @ApiModelProperty(example="null", value="The date on which the trusted group was added. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="The user that added trusted group.")
    @JsonProperty(value="createdBy")
    public OrgUser getCreatedBy() {
        return this.createdBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrustGroup trustGroup = (TrustGroup)o;
        return Objects.equals(this.id, trustGroup.id) && Objects.equals(this.name, trustGroup.name) && Objects.equals(this.description, trustGroup.description) && Objects.equals(this.dateModified, trustGroup.dateModified) && Objects.equals(this.memberCount, trustGroup.memberCount) && Objects.equals((Object)this.state, (Object)trustGroup.state) && Objects.equals(this.version, trustGroup.version) && Objects.equals((Object)this.type, (Object)trustGroup.type) && Objects.equals(this.images, trustGroup.images) && Objects.equals(this.addresses, trustGroup.addresses) && Objects.equals(this.rulesVisible, trustGroup.rulesVisible) && Objects.equals((Object)this.visibility, (Object)trustGroup.visibility) && Objects.equals(this.rolesEnabled, trustGroup.rolesEnabled) && Objects.equals(this.includeOwners, trustGroup.includeOwners) && Objects.equals(this.callsEnabled, trustGroup.callsEnabled) && Objects.equals(this.owners, trustGroup.owners) && Objects.equals(this.dateCreated, trustGroup.dateCreated) && Objects.equals(this.createdBy, trustGroup.createdBy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.dateModified, this.memberCount, this.state, this.version, this.type, this.images, this.addresses, this.rulesVisible, this.visibility, this.rolesEnabled, this.includeOwners, this.callsEnabled, this.owners, this.dateCreated, this.createdBy});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TrustGroup {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    memberCount: ").append(this.toIndentedString(this.memberCount)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    images: ").append(this.toIndentedString(this.images)).append("\n");
        sb.append("    addresses: ").append(this.toIndentedString(this.addresses)).append("\n");
        sb.append("    rulesVisible: ").append(this.toIndentedString(this.rulesVisible)).append("\n");
        sb.append("    visibility: ").append(this.toIndentedString((Object)this.visibility)).append("\n");
        sb.append("    rolesEnabled: ").append(this.toIndentedString(this.rolesEnabled)).append("\n");
        sb.append("    includeOwners: ").append(this.toIndentedString(this.includeOwners)).append("\n");
        sb.append("    callsEnabled: ").append(this.toIndentedString(this.callsEnabled)).append("\n");
        sb.append("    owners: ").append(this.toIndentedString(this.owners)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("active"),
        INACTIVE("inactive"),
        DELETED("deleted");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        OFFICIAL("official"),
        SOCIAL("social");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=VisibilityEnumDeserializer.class)
    public static enum VisibilityEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PUBLIC("public"),
        OWNERS("owners"),
        MEMBERS("members");

        private String value;

        private VisibilityEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static VisibilityEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (VisibilityEnum value : VisibilityEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return VisibilityEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class VisibilityEnumDeserializer
    extends StdDeserializer<VisibilityEnum> {
        public VisibilityEnumDeserializer() {
            super(VisibilityEnumDeserializer.class);
        }

        public VisibilityEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return VisibilityEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

