/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Mode constraints to observe when operating on a bot flow.")
public class TextBotTextModeConstraints
implements Serializable {
    private List<String> languagePreferences = null;
    private Integer noInputTimeoutMilliseconds = null;

    public TextBotTextModeConstraints() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.languagePreferences = new ArrayList<String>();
        }
    }

    public TextBotTextModeConstraints languagePreferences(List<String> languagePreferences) {
        this.languagePreferences = languagePreferences;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The list of language preferences by their ISO language code.")
    @JsonProperty(value="languagePreferences")
    public List<String> getLanguagePreferences() {
        return this.languagePreferences;
    }

    public void setLanguagePreferences(List<String> languagePreferences) {
        this.languagePreferences = languagePreferences;
    }

    public TextBotTextModeConstraints noInputTimeoutMilliseconds(Integer noInputTimeoutMilliseconds) {
        this.noInputTimeoutMilliseconds = noInputTimeoutMilliseconds;
        return this;
    }

    @ApiModelProperty(example="null", value="The amount of time, in milliseconds, before the client should send the 'NoInput' event  to trigger the \"no input\" bot response and handling on digital channels.  Note: This optional field will only be returned for 'Digital Bot Flow' turns.")
    @JsonProperty(value="noInputTimeoutMilliseconds")
    public Integer getNoInputTimeoutMilliseconds() {
        return this.noInputTimeoutMilliseconds;
    }

    public void setNoInputTimeoutMilliseconds(Integer noInputTimeoutMilliseconds) {
        this.noInputTimeoutMilliseconds = noInputTimeoutMilliseconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextBotTextModeConstraints textBotTextModeConstraints = (TextBotTextModeConstraints)o;
        return Objects.equals(this.languagePreferences, textBotTextModeConstraints.languagePreferences) && Objects.equals(this.noInputTimeoutMilliseconds, textBotTextModeConstraints.noInputTimeoutMilliseconds);
    }

    public int hashCode() {
        return Objects.hash(this.languagePreferences, this.noInputTimeoutMilliseconds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextBotTextModeConstraints {\n");
        sb.append("    languagePreferences: ").append(this.toIndentedString(this.languagePreferences)).append("\n");
        sb.append("    noInputTimeoutMilliseconds: ").append(this.toIndentedString(this.noInputTimeoutMilliseconds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

