/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.MediaTypes;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Reference to supported content profile associated with the integration")
public class SupportedContentReference
implements Serializable {
    private String id = null;
    private String name = null;
    private String selfUri = null;
    private MediaTypes mediaTypes = null;

    public SupportedContentReference() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public SupportedContentReference id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The SupportedContent unique identifier associated with this integration")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(example="null", value="The SupportedContent profile name")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(example="null", value="The SupportedContent profile URI")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    @ApiModelProperty(example="null", value="Media types definition for the supported content")
    @JsonProperty(value="mediaTypes")
    public MediaTypes getMediaTypes() {
        return this.mediaTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SupportedContentReference supportedContentReference = (SupportedContentReference)o;
        return Objects.equals(this.id, supportedContentReference.id) && Objects.equals(this.name, supportedContentReference.name) && Objects.equals(this.selfUri, supportedContentReference.selfUri) && Objects.equals(this.mediaTypes, supportedContentReference.mediaTypes);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.selfUri, this.mediaTypes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SupportedContentReference {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("    mediaTypes: ").append(this.toIndentedString(this.mediaTypes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

