/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class PresentedKnowledgeDocument
implements Serializable {
    private String documentId = null;
    private String documentVariationId = null;
    private String documentVersionId = null;
    private SurfacingMethodEnum surfacingMethod = null;

    public PresentedKnowledgeDocument() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public PresentedKnowledgeDocument documentId(String documentId) {
        this.documentId = documentId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the document.")
    @JsonProperty(value="documentId")
    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public PresentedKnowledgeDocument documentVariationId(String documentVariationId) {
        this.documentVariationId = documentVariationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The variation of the document.")
    @JsonProperty(value="documentVariationId")
    public String getDocumentVariationId() {
        return this.documentVariationId;
    }

    public void setDocumentVariationId(String documentVariationId) {
        this.documentVariationId = documentVariationId;
    }

    public PresentedKnowledgeDocument documentVersionId(String documentVersionId) {
        this.documentVersionId = documentVersionId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The version of the document.")
    @JsonProperty(value="documentVersionId")
    public String getDocumentVersionId() {
        return this.documentVersionId;
    }

    public void setDocumentVersionId(String documentVersionId) {
        this.documentVersionId = documentVersionId;
    }

    public PresentedKnowledgeDocument surfacingMethod(SurfacingMethodEnum surfacingMethod) {
        this.surfacingMethod = surfacingMethod;
        return this;
    }

    @ApiModelProperty(example="null", value="The method how knowledge was surfaced. Article: Full article was shown. Snippet: A snippet from the article was shown. Highlight: A highlighted answer in a snippet was shown.Generative: A generated answer in a snippet was shown.")
    @JsonProperty(value="surfacingMethod")
    public SurfacingMethodEnum getSurfacingMethod() {
        return this.surfacingMethod;
    }

    public void setSurfacingMethod(SurfacingMethodEnum surfacingMethod) {
        this.surfacingMethod = surfacingMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PresentedKnowledgeDocument presentedKnowledgeDocument = (PresentedKnowledgeDocument)o;
        return Objects.equals(this.documentId, presentedKnowledgeDocument.documentId) && Objects.equals(this.documentVariationId, presentedKnowledgeDocument.documentVariationId) && Objects.equals(this.documentVersionId, presentedKnowledgeDocument.documentVersionId) && Objects.equals((Object)this.surfacingMethod, (Object)presentedKnowledgeDocument.surfacingMethod);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.documentId, this.documentVariationId, this.documentVersionId, this.surfacingMethod});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PresentedKnowledgeDocument {\n");
        sb.append("    documentId: ").append(this.toIndentedString(this.documentId)).append("\n");
        sb.append("    documentVariationId: ").append(this.toIndentedString(this.documentVariationId)).append("\n");
        sb.append("    documentVersionId: ").append(this.toIndentedString(this.documentVersionId)).append("\n");
        sb.append("    surfacingMethod: ").append(this.toIndentedString((Object)this.surfacingMethod)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SurfacingMethodEnumDeserializer.class)
    public static enum SurfacingMethodEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNKNOWN("Unknown"),
        ARTICLE("Article"),
        SNIPPET("Snippet"),
        HIGHLIGHT("Highlight"),
        GENERATIVE("Generative");

        private String value;

        private SurfacingMethodEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SurfacingMethodEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SurfacingMethodEnum value : SurfacingMethodEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SurfacingMethodEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SurfacingMethodEnumDeserializer
    extends StdDeserializer<SurfacingMethodEnum> {
        public SurfacingMethodEnumDeserializer() {
            super(SurfacingMethodEnumDeserializer.class);
        }

        public SurfacingMethodEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SurfacingMethodEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

