/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Learning SCORM package")
public class LearningScormResponse
implements Serializable {
    private String id = null;
    private StatusEnum status = null;
    private String errorCode = null;
    private String errorMessage = null;
    private Float percentageUnpacked = null;
    private String selfUri = null;

    public LearningScormResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public LearningScormResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="The status of the SCORM package")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public LearningScormResponse errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @ApiModelProperty(example="null", value="The error code of the SCORM package (on failure)")
    @JsonProperty(value="errorCode")
    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public LearningScormResponse errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @ApiModelProperty(example="null", value="The error message associated with the error code")
    @JsonProperty(value="errorMessage")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public LearningScormResponse percentageUnpacked(Float percentageUnpacked) {
        this.percentageUnpacked = percentageUnpacked;
        return this;
    }

    @ApiModelProperty(example="null", value="The percentage of the SCORM package that has been unpacked")
    @JsonProperty(value="percentageUnpacked")
    public Float getPercentageUnpacked() {
        return this.percentageUnpacked;
    }

    public void setPercentageUnpacked(Float percentageUnpacked) {
        this.percentageUnpacked = percentageUnpacked;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LearningScormResponse learningScormResponse = (LearningScormResponse)o;
        return Objects.equals(this.id, learningScormResponse.id) && Objects.equals((Object)this.status, (Object)learningScormResponse.status) && Objects.equals(this.errorCode, learningScormResponse.errorCode) && Objects.equals(this.errorMessage, learningScormResponse.errorMessage) && Objects.equals(this.percentageUnpacked, learningScormResponse.percentageUnpacked) && Objects.equals(this.selfUri, learningScormResponse.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.status, this.errorCode, this.errorMessage, this.percentageUnpacked, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LearningScormResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    percentageUnpacked: ").append(this.toIndentedString(this.percentageUnpacked)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UPLOADPENDING("UploadPending"),
        UNPACKING("Unpacking"),
        ERROR("Error"),
        READY("Ready");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

