/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.EscalationTarget;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class EscalationRuleRequest
implements Serializable {
    private String name = null;
    private String matchCriteria = null;
    private Integer priority = null;
    private String divisionId = null;
    private String description = null;
    private StatusEnum status = null;
    private EscalationTarget openEscalation = null;
    private EscalationTarget facebookEscalation = null;
    private EscalationTarget instagramEscalation = null;
    private EscalationTarget twitterEscalation = null;

    public EscalationRuleRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public EscalationRuleRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the escalation rule.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EscalationRuleRequest matchCriteria(String matchCriteria) {
        this.matchCriteria = matchCriteria;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The criteria that defines when a social media message should be escalated.")
    @JsonProperty(value="matchCriteria")
    public String getMatchCriteria() {
        return this.matchCriteria;
    }

    public void setMatchCriteria(String matchCriteria) {
        this.matchCriteria = matchCriteria;
    }

    public EscalationRuleRequest priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The priority of the escalation rule. The lower the number the higer the priority. Once a rule is matched others are skipped.")
    @JsonProperty(value="priority")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public EscalationRuleRequest divisionId(String divisionId) {
        this.divisionId = divisionId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the division the social escalation rule belongs to.")
    @JsonProperty(value="divisionId")
    public String getDivisionId() {
        return this.divisionId;
    }

    public void setDivisionId(String divisionId) {
        this.divisionId = divisionId;
    }

    public EscalationRuleRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="A description of the social escalation rule.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public EscalationRuleRequest status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="The status of the escalation rule.")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public EscalationRuleRequest openEscalation(EscalationTarget openEscalation) {
        this.openEscalation = openEscalation;
        return this;
    }

    @ApiModelProperty(example="null", value="The target integration configuration used for an open social media message if the match criteria returns true.")
    @JsonProperty(value="openEscalation")
    public EscalationTarget getOpenEscalation() {
        return this.openEscalation;
    }

    public void setOpenEscalation(EscalationTarget openEscalation) {
        this.openEscalation = openEscalation;
    }

    public EscalationRuleRequest facebookEscalation(EscalationTarget facebookEscalation) {
        this.facebookEscalation = facebookEscalation;
        return this;
    }

    @ApiModelProperty(example="null", value="The target integration configuration used for a Facebook social media message if the match criteria returns true.")
    @JsonProperty(value="facebookEscalation")
    public EscalationTarget getFacebookEscalation() {
        return this.facebookEscalation;
    }

    public void setFacebookEscalation(EscalationTarget facebookEscalation) {
        this.facebookEscalation = facebookEscalation;
    }

    public EscalationRuleRequest instagramEscalation(EscalationTarget instagramEscalation) {
        this.instagramEscalation = instagramEscalation;
        return this;
    }

    @ApiModelProperty(example="null", value="The target integration configuration used for an Instagram social media message if the match criteria returns true.")
    @JsonProperty(value="instagramEscalation")
    public EscalationTarget getInstagramEscalation() {
        return this.instagramEscalation;
    }

    public void setInstagramEscalation(EscalationTarget instagramEscalation) {
        this.instagramEscalation = instagramEscalation;
    }

    public EscalationRuleRequest twitterEscalation(EscalationTarget twitterEscalation) {
        this.twitterEscalation = twitterEscalation;
        return this;
    }

    @ApiModelProperty(example="null", value="The target integration configuration used for a X (formerly Twitter) social media message if the match criteria returns true.")
    @JsonProperty(value="twitterEscalation")
    public EscalationTarget getTwitterEscalation() {
        return this.twitterEscalation;
    }

    public void setTwitterEscalation(EscalationTarget twitterEscalation) {
        this.twitterEscalation = twitterEscalation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EscalationRuleRequest escalationRuleRequest = (EscalationRuleRequest)o;
        return Objects.equals(this.name, escalationRuleRequest.name) && Objects.equals(this.matchCriteria, escalationRuleRequest.matchCriteria) && Objects.equals(this.priority, escalationRuleRequest.priority) && Objects.equals(this.divisionId, escalationRuleRequest.divisionId) && Objects.equals(this.description, escalationRuleRequest.description) && Objects.equals((Object)this.status, (Object)escalationRuleRequest.status) && Objects.equals(this.openEscalation, escalationRuleRequest.openEscalation) && Objects.equals(this.facebookEscalation, escalationRuleRequest.facebookEscalation) && Objects.equals(this.instagramEscalation, escalationRuleRequest.instagramEscalation) && Objects.equals(this.twitterEscalation, escalationRuleRequest.twitterEscalation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.matchCriteria, this.priority, this.divisionId, this.description, this.status, this.openEscalation, this.facebookEscalation, this.instagramEscalation, this.twitterEscalation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EscalationRuleRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    matchCriteria: ").append(this.toIndentedString(this.matchCriteria)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    divisionId: ").append(this.toIndentedString(this.divisionId)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    openEscalation: ").append(this.toIndentedString(this.openEscalation)).append("\n");
        sb.append("    facebookEscalation: ").append(this.toIndentedString(this.facebookEscalation)).append("\n");
        sb.append("    instagramEscalation: ").append(this.toIndentedString(this.instagramEscalation)).append("\n");
        sb.append("    twitterEscalation: ").append(this.toIndentedString(this.twitterEscalation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("Active"),
        PAUSED("Paused");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

