/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ConversationContentReceivedReplyMessage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="A Presence event.")
public class ConversationEventPresence
implements Serializable {
    private TypeEnum type = null;
    private ConversationContentReceivedReplyMessage receivedMessage = null;
    private ConversationContentReceivedReplyMessage replyMessage = null;

    public ConversationEventPresence() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public ConversationEventPresence type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Describes the type of Presence event.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ConversationEventPresence receivedMessage(ConversationContentReceivedReplyMessage receivedMessage) {
        this.receivedMessage = receivedMessage;
        return this;
    }

    @ApiModelProperty(example="null", value="The message displayed in the received message bubble.")
    @JsonProperty(value="receivedMessage")
    public ConversationContentReceivedReplyMessage getReceivedMessage() {
        return this.receivedMessage;
    }

    public void setReceivedMessage(ConversationContentReceivedReplyMessage receivedMessage) {
        this.receivedMessage = receivedMessage;
    }

    public ConversationEventPresence replyMessage(ConversationContentReceivedReplyMessage replyMessage) {
        this.replyMessage = replyMessage;
        return this;
    }

    @ApiModelProperty(example="null", value="The message displayed in the reply message bubble.")
    @JsonProperty(value="replyMessage")
    public ConversationContentReceivedReplyMessage getReplyMessage() {
        return this.replyMessage;
    }

    public void setReplyMessage(ConversationContentReceivedReplyMessage replyMessage) {
        this.replyMessage = replyMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationEventPresence conversationEventPresence = (ConversationEventPresence)o;
        return Objects.equals((Object)this.type, (Object)conversationEventPresence.type) && Objects.equals(this.receivedMessage, conversationEventPresence.receivedMessage) && Objects.equals(this.replyMessage, conversationEventPresence.replyMessage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.receivedMessage, this.replyMessage});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationEventPresence {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    receivedMessage: ").append(this.toIndentedString(this.receivedMessage)).append("\n");
        sb.append("    replyMessage: ").append(this.toIndentedString(this.replyMessage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        JOIN("Join"),
        DISCONNECT("Disconnect"),
        CLEAR("Clear"),
        SIGNIN("SignIn"),
        SESSIONEXPIRED("SessionExpired"),
        AUTHENTICATE("Authenticate");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

