/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.CallMediaParticipant;
import com.mypurecloud.sdk.v2.model.ConversationDivisionMembership;
import com.mypurecloud.sdk.v2.model.TransferResponse;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CallConversation
implements Serializable {
    private String id = null;
    private String name = null;
    private List<CallMediaParticipant> participants = null;
    private List<String> otherMediaUris = null;
    private List<TransferResponse> recentTransfers = null;
    private String utilizationLabelId = null;
    private List<ConversationDivisionMembership> divisions = null;
    private RecordingStateEnum recordingState = null;
    private Integer maxParticipants = null;
    private Boolean securePause = null;
    private String selfUri = null;

    public CallConversation() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.participants = new ArrayList<CallMediaParticipant>();
            this.otherMediaUris = new ArrayList<String>();
            this.recentTransfers = new ArrayList<TransferResponse>();
            this.divisions = new ArrayList<ConversationDivisionMembership>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public CallConversation name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CallConversation participants(List<CallMediaParticipant> participants) {
        this.participants = participants;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of participants involved in the conversation.")
    @JsonProperty(value="participants")
    public List<CallMediaParticipant> getParticipants() {
        return this.participants;
    }

    public void setParticipants(List<CallMediaParticipant> participants) {
        this.participants = participants;
    }

    public CallConversation otherMediaUris(List<String> otherMediaUris) {
        this.otherMediaUris = otherMediaUris;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of other media channels involved in the conversation.")
    @JsonProperty(value="otherMediaUris")
    public List<String> getOtherMediaUris() {
        return this.otherMediaUris;
    }

    public void setOtherMediaUris(List<String> otherMediaUris) {
        this.otherMediaUris = otherMediaUris;
    }

    public CallConversation recentTransfers(List<TransferResponse> recentTransfers) {
        this.recentTransfers = recentTransfers;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of the most recent 20 transfer commands applied to this conversation.")
    @JsonProperty(value="recentTransfers")
    public List<TransferResponse> getRecentTransfers() {
        return this.recentTransfers;
    }

    public void setRecentTransfers(List<TransferResponse> recentTransfers) {
        this.recentTransfers = recentTransfers;
    }

    public CallConversation utilizationLabelId(String utilizationLabelId) {
        this.utilizationLabelId = utilizationLabelId;
        return this;
    }

    @ApiModelProperty(example="null", value="An optional label that categorizes the conversation.  Max-utilization settings can be configured at a per-label level")
    @JsonProperty(value="utilizationLabelId")
    public String getUtilizationLabelId() {
        return this.utilizationLabelId;
    }

    public void setUtilizationLabelId(String utilizationLabelId) {
        this.utilizationLabelId = utilizationLabelId;
    }

    public CallConversation divisions(List<ConversationDivisionMembership> divisions) {
        this.divisions = divisions;
        return this;
    }

    @ApiModelProperty(example="null", value="Identifiers of divisions associated with this conversation.")
    @JsonProperty(value="divisions")
    public List<ConversationDivisionMembership> getDivisions() {
        return this.divisions;
    }

    public void setDivisions(List<ConversationDivisionMembership> divisions) {
        this.divisions = divisions;
    }

    public CallConversation recordingState(RecordingStateEnum recordingState) {
        this.recordingState = recordingState;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="recordingState")
    public RecordingStateEnum getRecordingState() {
        return this.recordingState;
    }

    public void setRecordingState(RecordingStateEnum recordingState) {
        this.recordingState = recordingState;
    }

    public CallConversation maxParticipants(Integer maxParticipants) {
        this.maxParticipants = maxParticipants;
        return this;
    }

    @ApiModelProperty(example="null", value="If this is a conference conversation, then this field indicates the maximum number of participants allowed to participant in the conference.")
    @JsonProperty(value="maxParticipants")
    public Integer getMaxParticipants() {
        return this.maxParticipants;
    }

    public void setMaxParticipants(Integer maxParticipants) {
        this.maxParticipants = maxParticipants;
    }

    public CallConversation securePause(Boolean securePause) {
        this.securePause = securePause;
        return this;
    }

    @ApiModelProperty(example="null", value="True when the recording of this conversation is in secure pause status.")
    @JsonProperty(value="securePause")
    public Boolean getSecurePause() {
        return this.securePause;
    }

    public void setSecurePause(Boolean securePause) {
        this.securePause = securePause;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallConversation callConversation = (CallConversation)o;
        return Objects.equals(this.id, callConversation.id) && Objects.equals(this.name, callConversation.name) && Objects.equals(this.participants, callConversation.participants) && Objects.equals(this.otherMediaUris, callConversation.otherMediaUris) && Objects.equals(this.recentTransfers, callConversation.recentTransfers) && Objects.equals(this.utilizationLabelId, callConversation.utilizationLabelId) && Objects.equals(this.divisions, callConversation.divisions) && Objects.equals((Object)this.recordingState, (Object)callConversation.recordingState) && Objects.equals(this.maxParticipants, callConversation.maxParticipants) && Objects.equals(this.securePause, callConversation.securePause) && Objects.equals(this.selfUri, callConversation.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.participants, this.otherMediaUris, this.recentTransfers, this.utilizationLabelId, this.divisions, this.recordingState, this.maxParticipants, this.securePause, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CallConversation {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    participants: ").append(this.toIndentedString(this.participants)).append("\n");
        sb.append("    otherMediaUris: ").append(this.toIndentedString(this.otherMediaUris)).append("\n");
        sb.append("    recentTransfers: ").append(this.toIndentedString(this.recentTransfers)).append("\n");
        sb.append("    utilizationLabelId: ").append(this.toIndentedString(this.utilizationLabelId)).append("\n");
        sb.append("    divisions: ").append(this.toIndentedString(this.divisions)).append("\n");
        sb.append("    recordingState: ").append(this.toIndentedString((Object)this.recordingState)).append("\n");
        sb.append("    maxParticipants: ").append(this.toIndentedString(this.maxParticipants)).append("\n");
        sb.append("    securePause: ").append(this.toIndentedString(this.securePause)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=RecordingStateEnumDeserializer.class)
    public static enum RecordingStateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NONE("none"),
        ACTIVE("active"),
        PAUSED("paused");

        private String value;

        private RecordingStateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RecordingStateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (RecordingStateEnum value : RecordingStateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return RecordingStateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class RecordingStateEnumDeserializer
    extends StdDeserializer<RecordingStateEnum> {
        public RecordingStateEnumDeserializer() {
            super(RecordingStateEnumDeserializer.class);
        }

        public RecordingStateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return RecordingStateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

