/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class ButtonResponse
implements Serializable {
    private TypeEnum type = null;
    private String text = null;
    private String payload = null;
    private MessageTypeEnum messageType = null;

    public ButtonResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public ButtonResponse type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="Button response type that captures Button and QuickReply type responses")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ButtonResponse text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="null", value="Text to show inside the Button reply. This is also used as the response text after clicking on the Button.")
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public ButtonResponse payload(String payload) {
        this.payload = payload;
        return this;
    }

    @ApiModelProperty(example="null", value="Content of the textback payload after clicking a button")
    @JsonProperty(value="payload")
    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public ButtonResponse messageType(MessageTypeEnum messageType) {
        this.messageType = messageType;
        return this;
    }

    @ApiModelProperty(example="null", value="Button response message type that captures QuickReply , Cards and Carousel .This is used  as label for Card selection")
    @JsonProperty(value="messageType")
    public MessageTypeEnum getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageTypeEnum messageType) {
        this.messageType = messageType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ButtonResponse buttonResponse = (ButtonResponse)o;
        return Objects.equals((Object)this.type, (Object)buttonResponse.type) && Objects.equals(this.text, buttonResponse.text) && Objects.equals(this.payload, buttonResponse.payload) && Objects.equals((Object)this.messageType, (Object)buttonResponse.messageType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.text, this.payload, this.messageType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ButtonResponse {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    payload: ").append(this.toIndentedString(this.payload)).append("\n");
        sb.append("    messageType: ").append(this.toIndentedString((Object)this.messageType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        BUTTON("Button"),
        QUICKREPLY("QuickReply"),
        DATEPICKER("DatePicker");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=MessageTypeEnumDeserializer.class)
    public static enum MessageTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        QUICKREPLY("QuickReply"),
        CARD("Card"),
        CAROUSEL("Carousel");

        private String value;

        private MessageTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MessageTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MessageTypeEnum value : MessageTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MessageTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MessageTypeEnumDeserializer
    extends StdDeserializer<MessageTypeEnum> {
        public MessageTypeEnumDeserializer() {
            super(MessageTypeEnumDeserializer.class);
        }

        public MessageTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MessageTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

