/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.SchedulerMessageTypeSeverity;
import com.mypurecloud.sdk.v2.model.SetWrapperSyncTimeOffProperty;
import com.mypurecloud.sdk.v2.model.WfmServiceGoalImpactSettings;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class BuSchedulingSettingsRequest
implements Serializable {
    private List<SchedulerMessageTypeSeverity> messageSeverities = null;
    private SetWrapperSyncTimeOffProperty syncTimeOffProperties = null;
    private WfmServiceGoalImpactSettings serviceGoalImpact = null;
    private Boolean allowWorkPlanPerMinuteGranularity = null;
    private ActivitySmoothingTypeEnum activitySmoothingType = null;
    private Boolean induceScheduleVariability = null;

    public BuSchedulingSettingsRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.messageSeverities = new ArrayList<SchedulerMessageTypeSeverity>();
        }
    }

    public BuSchedulingSettingsRequest messageSeverities(List<SchedulerMessageTypeSeverity> messageSeverities) {
        this.messageSeverities = messageSeverities;
        return this;
    }

    @ApiModelProperty(example="null", value="Schedule generation message severity configuration")
    @JsonProperty(value="messageSeverities")
    public List<SchedulerMessageTypeSeverity> getMessageSeverities() {
        return this.messageSeverities;
    }

    public void setMessageSeverities(List<SchedulerMessageTypeSeverity> messageSeverities) {
        this.messageSeverities = messageSeverities;
    }

    public BuSchedulingSettingsRequest syncTimeOffProperties(SetWrapperSyncTimeOffProperty syncTimeOffProperties) {
        this.syncTimeOffProperties = syncTimeOffProperties;
        return this;
    }

    @ApiModelProperty(example="null", value="Synchronize set of time off properties from scheduled activities to time off requests when the schedule is published.")
    @JsonProperty(value="syncTimeOffProperties")
    public SetWrapperSyncTimeOffProperty getSyncTimeOffProperties() {
        return this.syncTimeOffProperties;
    }

    public void setSyncTimeOffProperties(SetWrapperSyncTimeOffProperty syncTimeOffProperties) {
        this.syncTimeOffProperties = syncTimeOffProperties;
    }

    public BuSchedulingSettingsRequest serviceGoalImpact(WfmServiceGoalImpactSettings serviceGoalImpact) {
        this.serviceGoalImpact = serviceGoalImpact;
        return this;
    }

    @ApiModelProperty(example="null", value="Configures the max percent increase and decrease of service goals for this business unit")
    @JsonProperty(value="serviceGoalImpact")
    public WfmServiceGoalImpactSettings getServiceGoalImpact() {
        return this.serviceGoalImpact;
    }

    public void setServiceGoalImpact(WfmServiceGoalImpactSettings serviceGoalImpact) {
        this.serviceGoalImpact = serviceGoalImpact;
    }

    public BuSchedulingSettingsRequest allowWorkPlanPerMinuteGranularity(Boolean allowWorkPlanPerMinuteGranularity) {
        this.allowWorkPlanPerMinuteGranularity = allowWorkPlanPerMinuteGranularity;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether or not per minute granularity for scheduling will be enabled for this business unit. Defaults to false.")
    @JsonProperty(value="allowWorkPlanPerMinuteGranularity")
    public Boolean getAllowWorkPlanPerMinuteGranularity() {
        return this.allowWorkPlanPerMinuteGranularity;
    }

    public void setAllowWorkPlanPerMinuteGranularity(Boolean allowWorkPlanPerMinuteGranularity) {
        this.allowWorkPlanPerMinuteGranularity = allowWorkPlanPerMinuteGranularity;
    }

    public BuSchedulingSettingsRequest activitySmoothingType(ActivitySmoothingTypeEnum activitySmoothingType) {
        this.activitySmoothingType = activitySmoothingType;
        return this;
    }

    @ApiModelProperty(example="null", value="The activity smoothing type for schedule generation in this business unit")
    @JsonProperty(value="activitySmoothingType")
    public ActivitySmoothingTypeEnum getActivitySmoothingType() {
        return this.activitySmoothingType;
    }

    public void setActivitySmoothingType(ActivitySmoothingTypeEnum activitySmoothingType) {
        this.activitySmoothingType = activitySmoothingType;
    }

    public BuSchedulingSettingsRequest induceScheduleVariability(Boolean induceScheduleVariability) {
        this.induceScheduleVariability = induceScheduleVariability;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether to provide variability in schedule generation")
    @JsonProperty(value="induceScheduleVariability")
    public Boolean getInduceScheduleVariability() {
        return this.induceScheduleVariability;
    }

    public void setInduceScheduleVariability(Boolean induceScheduleVariability) {
        this.induceScheduleVariability = induceScheduleVariability;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuSchedulingSettingsRequest buSchedulingSettingsRequest = (BuSchedulingSettingsRequest)o;
        return Objects.equals(this.messageSeverities, buSchedulingSettingsRequest.messageSeverities) && Objects.equals(this.syncTimeOffProperties, buSchedulingSettingsRequest.syncTimeOffProperties) && Objects.equals(this.serviceGoalImpact, buSchedulingSettingsRequest.serviceGoalImpact) && Objects.equals(this.allowWorkPlanPerMinuteGranularity, buSchedulingSettingsRequest.allowWorkPlanPerMinuteGranularity) && Objects.equals((Object)this.activitySmoothingType, (Object)buSchedulingSettingsRequest.activitySmoothingType) && Objects.equals(this.induceScheduleVariability, buSchedulingSettingsRequest.induceScheduleVariability);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.messageSeverities, this.syncTimeOffProperties, this.serviceGoalImpact, this.allowWorkPlanPerMinuteGranularity, this.activitySmoothingType, this.induceScheduleVariability});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BuSchedulingSettingsRequest {\n");
        sb.append("    messageSeverities: ").append(this.toIndentedString(this.messageSeverities)).append("\n");
        sb.append("    syncTimeOffProperties: ").append(this.toIndentedString(this.syncTimeOffProperties)).append("\n");
        sb.append("    serviceGoalImpact: ").append(this.toIndentedString(this.serviceGoalImpact)).append("\n");
        sb.append("    allowWorkPlanPerMinuteGranularity: ").append(this.toIndentedString(this.allowWorkPlanPerMinuteGranularity)).append("\n");
        sb.append("    activitySmoothingType: ").append(this.toIndentedString((Object)this.activitySmoothingType)).append("\n");
        sb.append("    induceScheduleVariability: ").append(this.toIndentedString(this.induceScheduleVariability)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ActivitySmoothingTypeEnumDeserializer.class)
    public static enum ActivitySmoothingTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        REDUCECONCURRENTACTIVITIESACROSSBU("ReduceConcurrentActivitiesAcrossBu"),
        REDUCECONCURRENTACTIVITIESACROSSMU("ReduceConcurrentActivitiesAcrossMu"),
        CONSISTENTSERVICELEVEL("ConsistentServiceLevel");

        private String value;

        private ActivitySmoothingTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActivitySmoothingTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActivitySmoothingTypeEnum value : ActivitySmoothingTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActivitySmoothingTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ActivitySmoothingTypeEnumDeserializer
    extends StdDeserializer<ActivitySmoothingTypeEnum> {
        public ActivitySmoothingTypeEnumDeserializer() {
            super(ActivitySmoothingTypeEnumDeserializer.class);
        }

        public ActivitySmoothingTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ActivitySmoothingTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

