/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.BuAgentScheduleActivity;
import com.mypurecloud.sdk.v2.model.BuScheduleReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class BuAgentScheduleShiftRequest
implements Serializable {
    private String id = null;
    private Date startDate = null;
    private Integer lengthMinutes = null;
    private List<BuAgentScheduleActivity> activities = null;
    private Boolean manuallyEdited = null;
    private BuScheduleReference schedule = null;

    public BuAgentScheduleShiftRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.activities = new ArrayList<BuAgentScheduleActivity>();
        }
    }

    public BuAgentScheduleShiftRequest id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the shift")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(example="null", value="The start date of this shift. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startDate")
    public Date getStartDate() {
        return this.startDate;
    }

    @ApiModelProperty(example="null", value="The length of this shift in minutes")
    @JsonProperty(value="lengthMinutes")
    public Integer getLengthMinutes() {
        return this.lengthMinutes;
    }

    public BuAgentScheduleShiftRequest activities(List<BuAgentScheduleActivity> activities) {
        this.activities = activities;
        return this;
    }

    @ApiModelProperty(example="null", value="The activities associated with this shift")
    @JsonProperty(value="activities")
    public List<BuAgentScheduleActivity> getActivities() {
        return this.activities;
    }

    public void setActivities(List<BuAgentScheduleActivity> activities) {
        this.activities = activities;
    }

    public BuAgentScheduleShiftRequest manuallyEdited(Boolean manuallyEdited) {
        this.manuallyEdited = manuallyEdited;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this shift was manually edited. This is only set by clients and is used for rescheduling")
    @JsonProperty(value="manuallyEdited")
    public Boolean getManuallyEdited() {
        return this.manuallyEdited;
    }

    public void setManuallyEdited(Boolean manuallyEdited) {
        this.manuallyEdited = manuallyEdited;
    }

    @ApiModelProperty(example="null", value="The schedule to which this shift belongs")
    @JsonProperty(value="schedule")
    public BuScheduleReference getSchedule() {
        return this.schedule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuAgentScheduleShiftRequest buAgentScheduleShiftRequest = (BuAgentScheduleShiftRequest)o;
        return Objects.equals(this.id, buAgentScheduleShiftRequest.id) && Objects.equals(this.startDate, buAgentScheduleShiftRequest.startDate) && Objects.equals(this.lengthMinutes, buAgentScheduleShiftRequest.lengthMinutes) && Objects.equals(this.activities, buAgentScheduleShiftRequest.activities) && Objects.equals(this.manuallyEdited, buAgentScheduleShiftRequest.manuallyEdited) && Objects.equals(this.schedule, buAgentScheduleShiftRequest.schedule);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.startDate, this.lengthMinutes, this.activities, this.manuallyEdited, this.schedule);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BuAgentScheduleShiftRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    lengthMinutes: ").append(this.toIndentedString(this.lengthMinutes)).append("\n");
        sb.append("    activities: ").append(this.toIndentedString(this.activities)).append("\n");
        sb.append("    manuallyEdited: ").append(this.toIndentedString(this.manuallyEdited)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

