/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.User;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Annotation
implements Serializable {
    private String id = null;
    private String name = null;
    private String type = null;
    private Long location = null;
    private Long durationMs = null;
    private Long absoluteLocation = null;
    private Long absoluteDurationMs = null;
    private Long recordingLocation = null;
    private Long recordingDurationMs = null;
    private User user = null;
    private String description = null;
    private ReasonEnum reason = null;
    private List<Annotation> annotations = null;
    private Long realtimeLocation = null;
    private String selfUri = null;

    public Annotation() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.annotations = new ArrayList<Annotation>();
        }
    }

    public Annotation id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="Annotation id. All pause annotations on a recording will share an ID value, bookmark annotations will have unique IDs, and hold annotations will have randomly generated UUIDs (i.e. the ID will change at each request).")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Annotation name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Annotation type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Annotation location(Long location) {
        this.location = location;
        return this;
    }

    @ApiModelProperty(example="null", value="Offset of annotation in milliseconds.")
    @JsonProperty(value="location")
    public Long getLocation() {
        return this.location;
    }

    public void setLocation(Long location) {
        this.location = location;
    }

    public Annotation durationMs(Long durationMs) {
        this.durationMs = durationMs;
        return this;
    }

    @ApiModelProperty(example="null", value="Duration of annotation in milliseconds.")
    @JsonProperty(value="durationMs")
    public Long getDurationMs() {
        return this.durationMs;
    }

    public void setDurationMs(Long durationMs) {
        this.durationMs = durationMs;
    }

    public Annotation absoluteLocation(Long absoluteLocation) {
        this.absoluteLocation = absoluteLocation;
        return this;
    }

    @ApiModelProperty(example="null", value="Offset of annotation (milliseconds) from start of recording (after removing the cumulative duration of all pauses).")
    @JsonProperty(value="absoluteLocation")
    public Long getAbsoluteLocation() {
        return this.absoluteLocation;
    }

    public void setAbsoluteLocation(Long absoluteLocation) {
        this.absoluteLocation = absoluteLocation;
    }

    public Annotation absoluteDurationMs(Long absoluteDurationMs) {
        this.absoluteDurationMs = absoluteDurationMs;
        return this;
    }

    @ApiModelProperty(example="null", value="Duration of annotation (milliseconds).")
    @JsonProperty(value="absoluteDurationMs")
    public Long getAbsoluteDurationMs() {
        return this.absoluteDurationMs;
    }

    public void setAbsoluteDurationMs(Long absoluteDurationMs) {
        this.absoluteDurationMs = absoluteDurationMs;
    }

    public Annotation recordingLocation(Long recordingLocation) {
        this.recordingLocation = recordingLocation;
        return this;
    }

    @ApiModelProperty(example="null", value="Offset of annotation (milliseconds) from start of recording, adjusted for any recording cuts")
    @JsonProperty(value="recordingLocation")
    public Long getRecordingLocation() {
        return this.recordingLocation;
    }

    public void setRecordingLocation(Long recordingLocation) {
        this.recordingLocation = recordingLocation;
    }

    public Annotation recordingDurationMs(Long recordingDurationMs) {
        this.recordingDurationMs = recordingDurationMs;
        return this;
    }

    @ApiModelProperty(example="null", value="Duration of annotation (milliseconds), adjusted for any recording cuts.")
    @JsonProperty(value="recordingDurationMs")
    public Long getRecordingDurationMs() {
        return this.recordingDurationMs;
    }

    public void setRecordingDurationMs(Long recordingDurationMs) {
        this.recordingDurationMs = recordingDurationMs;
    }

    public Annotation user(User user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="User that created this annotation (if any).")
    @JsonProperty(value="user")
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Annotation description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="Text of annotation. Maximum character limit is 500.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(example="null", value="Reason for a pause annotation. Valid values: Hold,SecurePause,FlowOrQueue,Pause")
    @JsonProperty(value="reason")
    public ReasonEnum getReason() {
        return this.reason;
    }

    @ApiModelProperty(example="null", value="List of annotations")
    @JsonProperty(value="annotations")
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @ApiModelProperty(example="null", value="Offset of annotation (milliseconds) from start of the recording before removing the cumulative duration of all pauses before this annotation")
    @JsonProperty(value="realtimeLocation")
    public Long getRealtimeLocation() {
        return this.realtimeLocation;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Annotation annotation = (Annotation)o;
        return Objects.equals(this.id, annotation.id) && Objects.equals(this.name, annotation.name) && Objects.equals(this.type, annotation.type) && Objects.equals(this.location, annotation.location) && Objects.equals(this.durationMs, annotation.durationMs) && Objects.equals(this.absoluteLocation, annotation.absoluteLocation) && Objects.equals(this.absoluteDurationMs, annotation.absoluteDurationMs) && Objects.equals(this.recordingLocation, annotation.recordingLocation) && Objects.equals(this.recordingDurationMs, annotation.recordingDurationMs) && Objects.equals(this.user, annotation.user) && Objects.equals(this.description, annotation.description) && Objects.equals((Object)this.reason, (Object)annotation.reason) && Objects.equals(this.annotations, annotation.annotations) && Objects.equals(this.realtimeLocation, annotation.realtimeLocation) && Objects.equals(this.selfUri, annotation.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.type, this.location, this.durationMs, this.absoluteLocation, this.absoluteDurationMs, this.recordingLocation, this.recordingDurationMs, this.user, this.description, this.reason, this.annotations, this.realtimeLocation, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Annotation {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    durationMs: ").append(this.toIndentedString(this.durationMs)).append("\n");
        sb.append("    absoluteLocation: ").append(this.toIndentedString(this.absoluteLocation)).append("\n");
        sb.append("    absoluteDurationMs: ").append(this.toIndentedString(this.absoluteDurationMs)).append("\n");
        sb.append("    recordingLocation: ").append(this.toIndentedString(this.recordingLocation)).append("\n");
        sb.append("    recordingDurationMs: ").append(this.toIndentedString(this.recordingDurationMs)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString((Object)this.reason)).append("\n");
        sb.append("    annotations: ").append(this.toIndentedString(this.annotations)).append("\n");
        sb.append("    realtimeLocation: ").append(this.toIndentedString(this.realtimeLocation)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ReasonEnumDeserializer.class)
    public static enum ReasonEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        HOLD("Hold"),
        SECUREPAUSE("SecurePause"),
        FLOWORQUEUE("FlowOrQueue"),
        PAUSE("Pause");

        private String value;

        private ReasonEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ReasonEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ReasonEnum value : ReasonEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ReasonEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ReasonEnumDeserializer
    extends StdDeserializer<ReasonEnum> {
        public ReasonEnumDeserializer() {
            super(ReasonEnumDeserializer.class);
        }

        public ReasonEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ReasonEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

