/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.WfmVersionedEntityMetadata;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class ActivityCode
implements Serializable {
    private String id = null;
    private String selfUri = null;
    private String name = null;
    private Boolean isActive = null;
    private Boolean isDefault = null;
    private CategoryEnum category = null;
    private Integer lengthInMinutes = null;
    private Boolean countsAsPaidTime = null;
    private Boolean countsAsWorkTime = null;
    private Boolean agentTimeOffSelectable = null;
    private WfmVersionedEntityMetadata metadata = null;

    public ActivityCode() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public ActivityCode name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the activity code. Default activity codes will be created with an empty name")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ActivityCode isActive(Boolean isActive) {
        this.isActive = isActive;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this activity code is active or has been deleted")
    @JsonProperty(value="isActive")
    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public ActivityCode isDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this is a default activity code")
    @JsonProperty(value="isDefault")
    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public ActivityCode category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(example="null", value="The activity code's category.")
    @JsonProperty(value="category")
    public CategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public ActivityCode lengthInMinutes(Integer lengthInMinutes) {
        this.lengthInMinutes = lengthInMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="The default length of the activity in minutes")
    @JsonProperty(value="lengthInMinutes")
    public Integer getLengthInMinutes() {
        return this.lengthInMinutes;
    }

    public void setLengthInMinutes(Integer lengthInMinutes) {
        this.lengthInMinutes = lengthInMinutes;
    }

    public ActivityCode countsAsPaidTime(Boolean countsAsPaidTime) {
        this.countsAsPaidTime = countsAsPaidTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether an agent is paid while performing this activity")
    @JsonProperty(value="countsAsPaidTime")
    public Boolean getCountsAsPaidTime() {
        return this.countsAsPaidTime;
    }

    public void setCountsAsPaidTime(Boolean countsAsPaidTime) {
        this.countsAsPaidTime = countsAsPaidTime;
    }

    public ActivityCode countsAsWorkTime(Boolean countsAsWorkTime) {
        this.countsAsWorkTime = countsAsWorkTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether or not the activity should be counted as contiguous work time for calculating daily constraints")
    @JsonProperty(value="countsAsWorkTime")
    public Boolean getCountsAsWorkTime() {
        return this.countsAsWorkTime;
    }

    public void setCountsAsWorkTime(Boolean countsAsWorkTime) {
        this.countsAsWorkTime = countsAsWorkTime;
    }

    public ActivityCode agentTimeOffSelectable(Boolean agentTimeOffSelectable) {
        this.agentTimeOffSelectable = agentTimeOffSelectable;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether an agent can select this activity code when creating or editing a time off request. Null if the activity's category is not time off.")
    @JsonProperty(value="agentTimeOffSelectable")
    public Boolean getAgentTimeOffSelectable() {
        return this.agentTimeOffSelectable;
    }

    public void setAgentTimeOffSelectable(Boolean agentTimeOffSelectable) {
        this.agentTimeOffSelectable = agentTimeOffSelectable;
    }

    public ActivityCode metadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Version metadata for the associated management unit's list of activity codes")
    @JsonProperty(value="metadata")
    public WfmVersionedEntityMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityCode activityCode = (ActivityCode)o;
        return Objects.equals(this.id, activityCode.id) && Objects.equals(this.selfUri, activityCode.selfUri) && Objects.equals(this.name, activityCode.name) && Objects.equals(this.isActive, activityCode.isActive) && Objects.equals(this.isDefault, activityCode.isDefault) && Objects.equals((Object)this.category, (Object)activityCode.category) && Objects.equals(this.lengthInMinutes, activityCode.lengthInMinutes) && Objects.equals(this.countsAsPaidTime, activityCode.countsAsPaidTime) && Objects.equals(this.countsAsWorkTime, activityCode.countsAsWorkTime) && Objects.equals(this.agentTimeOffSelectable, activityCode.agentTimeOffSelectable) && Objects.equals(this.metadata, activityCode.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.selfUri, this.name, this.isActive, this.isDefault, this.category, this.lengthInMinutes, this.countsAsPaidTime, this.countsAsWorkTime, this.agentTimeOffSelectable, this.metadata});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActivityCode {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    isActive: ").append(this.toIndentedString(this.isActive)).append("\n");
        sb.append("    isDefault: ").append(this.toIndentedString(this.isDefault)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    lengthInMinutes: ").append(this.toIndentedString(this.lengthInMinutes)).append("\n");
        sb.append("    countsAsPaidTime: ").append(this.toIndentedString(this.countsAsPaidTime)).append("\n");
        sb.append("    countsAsWorkTime: ").append(this.toIndentedString(this.countsAsWorkTime)).append("\n");
        sb.append("    agentTimeOffSelectable: ").append(this.toIndentedString(this.agentTimeOffSelectable)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=CategoryEnumDeserializer.class)
    public static enum CategoryEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ONQUEUEWORK("OnQueueWork"),
        BREAK("Break"),
        MEAL("Meal"),
        MEETING("Meeting"),
        OFFQUEUEWORK("OffQueueWork"),
        TIMEOFF("TimeOff"),
        TRAINING("Training"),
        UNAVAILABLE("Unavailable"),
        UNSCHEDULED("Unscheduled");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CategoryEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CategoryEnum value : CategoryEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CategoryEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class CategoryEnumDeserializer
    extends StdDeserializer<CategoryEnum> {
        public CategoryEnumDeserializer() {
            super(CategoryEnumDeserializer.class);
        }

        public CategoryEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return CategoryEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

