/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.AuthorizationPolicy;
import java.util.HashMap;
import java.util.Map;

public class PutAuthorizationPolicyRequest {
    private String policyId;
    private AuthorizationPolicy body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getPolicyId() {
        return this.policyId;
    }

    public void setPolicyId(String policyId) {
        this.policyId = policyId;
    }

    public PutAuthorizationPolicyRequest withPolicyId(String policyId) {
        this.setPolicyId(policyId);
        return this;
    }

    public AuthorizationPolicy getBody() {
        return this.body;
    }

    public void setBody(AuthorizationPolicy body) {
        this.body = body;
    }

    public PutAuthorizationPolicyRequest withBody(AuthorizationPolicy body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutAuthorizationPolicyRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<AuthorizationPolicy> withHttpInfo() {
        if (this.policyId == null) {
            throw new IllegalStateException("Missing the required parameter 'policyId' when building request for PutAuthorizationPolicyRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutAuthorizationPolicyRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/authorization/policies/{policyId}").withPathParameter("policyId", this.policyId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String policyId, AuthorizationPolicy body) {
        return new Builder().withRequiredParams(policyId, body);
    }

    public static class Builder {
        private final PutAuthorizationPolicyRequest request = new PutAuthorizationPolicyRequest();

        private Builder() {
        }

        public Builder withPolicyId(String policyId) {
            this.request.setPolicyId(policyId);
            return this;
        }

        public Builder withBody(AuthorizationPolicy body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String policyId, AuthorizationPolicy body) {
            this.request.setPolicyId(policyId);
            this.request.setBody(body);
            return this;
        }

        public PutAuthorizationPolicyRequest build() {
            if (this.request.policyId == null) {
                throw new IllegalStateException("Missing the required parameter 'policyId' when building request for PutAuthorizationPolicyRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutAuthorizationPolicyRequest.");
            }
            return this.request;
        }
    }
}

