/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.SendMessageBody;
import java.util.HashMap;
import java.util.Map;

public class PatchChatsUserMessageRequest {
    private String userId;
    private String messageId;
    private SendMessageBody body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public PatchChatsUserMessageRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public PatchChatsUserMessageRequest withMessageId(String messageId) {
        this.setMessageId(messageId);
        return this;
    }

    public SendMessageBody getBody() {
        return this.body;
    }

    public void setBody(SendMessageBody body) {
        this.body = body;
    }

    public PatchChatsUserMessageRequest withBody(SendMessageBody body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchChatsUserMessageRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<SendMessageBody> withHttpInfo() {
        if (this.userId == null) {
            throw new IllegalStateException("Missing the required parameter 'userId' when building request for PatchChatsUserMessageRequest.");
        }
        if (this.messageId == null) {
            throw new IllegalStateException("Missing the required parameter 'messageId' when building request for PatchChatsUserMessageRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchChatsUserMessageRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/chats/users/{userId}/messages/{messageId}").withPathParameter("userId", this.userId).withPathParameter("messageId", this.messageId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String userId, String messageId, SendMessageBody body) {
        return new Builder().withRequiredParams(userId, messageId, body);
    }

    public static class Builder {
        private final PatchChatsUserMessageRequest request = new PatchChatsUserMessageRequest();

        private Builder() {
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withMessageId(String messageId) {
            this.request.setMessageId(messageId);
            return this;
        }

        public Builder withBody(SendMessageBody body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String userId, String messageId, SendMessageBody body) {
            this.request.setUserId(userId);
            this.request.setMessageId(messageId);
            this.request.setBody(body);
            return this;
        }

        public PatchChatsUserMessageRequest build() {
            if (this.request.userId == null) {
                throw new IllegalStateException("Missing the required parameter 'userId' when building request for PatchChatsUserMessageRequest.");
            }
            if (this.request.messageId == null) {
                throw new IllegalStateException("Missing the required parameter 'messageId' when building request for PatchChatsUserMessageRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchChatsUserMessageRequest.");
            }
            return this.request;
        }
    }
}

