/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetUserExternalidAuthorityNameRequest {
    private String userId;
    private String authorityName;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public GetUserExternalidAuthorityNameRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public String getAuthorityName() {
        return this.authorityName;
    }

    public void setAuthorityName(String authorityName) {
        this.authorityName = authorityName;
    }

    public GetUserExternalidAuthorityNameRequest withAuthorityName(String authorityName) {
        this.setAuthorityName(authorityName);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetUserExternalidAuthorityNameRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.userId == null) {
            throw new IllegalStateException("Missing the required parameter 'userId' when building request for GetUserExternalidAuthorityNameRequest.");
        }
        if (this.authorityName == null) {
            throw new IllegalStateException("Missing the required parameter 'authorityName' when building request for GetUserExternalidAuthorityNameRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/users/{userId}/externalid/{authorityName}").withPathParameter("userId", this.userId).withPathParameter("authorityName", this.authorityName).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String userId, String authorityName) {
        return new Builder().withRequiredParams(userId, authorityName);
    }

    public static class Builder {
        private final GetUserExternalidAuthorityNameRequest request = new GetUserExternalidAuthorityNameRequest();

        private Builder() {
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withAuthorityName(String authorityName) {
            this.request.setAuthorityName(authorityName);
            return this;
        }

        public Builder withRequiredParams(String userId, String authorityName) {
            this.request.setUserId(userId);
            this.request.setAuthorityName(authorityName);
            return this;
        }

        public GetUserExternalidAuthorityNameRequest build() {
            if (this.request.userId == null) {
                throw new IllegalStateException("Missing the required parameter 'userId' when building request for GetUserExternalidAuthorityNameRequest.");
            }
            if (this.request.authorityName == null) {
                throw new IllegalStateException("Missing the required parameter 'authorityName' when building request for GetUserExternalidAuthorityNameRequest.");
            }
            return this.request;
        }
    }
}

