/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class Station
implements Serializable {
    private String id = null;
    private String name = null;
    private String description = null;
    private StatusEnum status = null;
    private String userId = null;
    private String webRtcUserId = null;
    private DomainEntityRef primaryEdge = null;
    private DomainEntityRef secondaryEdge = null;
    private String type = null;
    private String lineAppearanceId = null;
    private Integer webRtcMediaDscp = null;
    private Boolean webRtcPersistentEnabled = null;
    private Boolean webRtcForceTurn = null;
    private Integer webRtcCallAppearances = null;
    private Boolean webRtcRequireMediaHelper = null;
    private String selfUri = null;

    public Station() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public Station name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Station description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Station status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Station userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(example="null", value="The Id of the user currently logged in and associated with the station.")
    @JsonProperty(value="userId")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Station webRtcUserId(String webRtcUserId) {
        this.webRtcUserId = webRtcUserId;
        return this;
    }

    @ApiModelProperty(example="null", value="The Id of the user configured for the station if it is of type inin_webrtc_softphone. Empty if station type is not inin_webrtc_softphone.")
    @JsonProperty(value="webRtcUserId")
    public String getWebRtcUserId() {
        return this.webRtcUserId;
    }

    public void setWebRtcUserId(String webRtcUserId) {
        this.webRtcUserId = webRtcUserId;
    }

    public Station primaryEdge(DomainEntityRef primaryEdge) {
        this.primaryEdge = primaryEdge;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="primaryEdge")
    public DomainEntityRef getPrimaryEdge() {
        return this.primaryEdge;
    }

    public void setPrimaryEdge(DomainEntityRef primaryEdge) {
        this.primaryEdge = primaryEdge;
    }

    public Station secondaryEdge(DomainEntityRef secondaryEdge) {
        this.secondaryEdge = secondaryEdge;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="secondaryEdge")
    public DomainEntityRef getSecondaryEdge() {
        return this.secondaryEdge;
    }

    public void setSecondaryEdge(DomainEntityRef secondaryEdge) {
        this.secondaryEdge = secondaryEdge;
    }

    public Station type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Station lineAppearanceId(String lineAppearanceId) {
        this.lineAppearanceId = lineAppearanceId;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="lineAppearanceId")
    public String getLineAppearanceId() {
        return this.lineAppearanceId;
    }

    public void setLineAppearanceId(String lineAppearanceId) {
        this.lineAppearanceId = lineAppearanceId;
    }

    @ApiModelProperty(example="null", value="The default or configured value of media dscp for the station. Empty if station type is not inin_webrtc_softphone.")
    @JsonProperty(value="webRtcMediaDscp")
    public Integer getWebRtcMediaDscp() {
        return this.webRtcMediaDscp;
    }

    @ApiModelProperty(example="null", value="The default or configured value of persistent connection setting for the station. Empty if station type is not inin_webrtc_softphone.")
    @JsonProperty(value="webRtcPersistentEnabled")
    public Boolean getWebRtcPersistentEnabled() {
        return this.webRtcPersistentEnabled;
    }

    @ApiModelProperty(example="null", value="Whether the station is configured to require TURN for routing WebRTC calls. Empty if station type is not inin_webrtc_softphone.")
    @JsonProperty(value="webRtcForceTurn")
    public Boolean getWebRtcForceTurn() {
        return this.webRtcForceTurn;
    }

    @ApiModelProperty(example="null", value="The number of call appearances on the station.")
    @JsonProperty(value="webRtcCallAppearances")
    public Integer getWebRtcCallAppearances() {
        return this.webRtcCallAppearances;
    }

    @ApiModelProperty(example="null", value="True when the media helper required.")
    @JsonProperty(value="webRtcRequireMediaHelper")
    public Boolean getWebRtcRequireMediaHelper() {
        return this.webRtcRequireMediaHelper;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Station station = (Station)o;
        return Objects.equals(this.id, station.id) && Objects.equals(this.name, station.name) && Objects.equals(this.description, station.description) && Objects.equals((Object)this.status, (Object)station.status) && Objects.equals(this.userId, station.userId) && Objects.equals(this.webRtcUserId, station.webRtcUserId) && Objects.equals(this.primaryEdge, station.primaryEdge) && Objects.equals(this.secondaryEdge, station.secondaryEdge) && Objects.equals(this.type, station.type) && Objects.equals(this.lineAppearanceId, station.lineAppearanceId) && Objects.equals(this.webRtcMediaDscp, station.webRtcMediaDscp) && Objects.equals(this.webRtcPersistentEnabled, station.webRtcPersistentEnabled) && Objects.equals(this.webRtcForceTurn, station.webRtcForceTurn) && Objects.equals(this.webRtcCallAppearances, station.webRtcCallAppearances) && Objects.equals(this.webRtcRequireMediaHelper, station.webRtcRequireMediaHelper) && Objects.equals(this.selfUri, station.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.status, this.userId, this.webRtcUserId, this.primaryEdge, this.secondaryEdge, this.type, this.lineAppearanceId, this.webRtcMediaDscp, this.webRtcPersistentEnabled, this.webRtcForceTurn, this.webRtcCallAppearances, this.webRtcRequireMediaHelper, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Station {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    webRtcUserId: ").append(this.toIndentedString(this.webRtcUserId)).append("\n");
        sb.append("    primaryEdge: ").append(this.toIndentedString(this.primaryEdge)).append("\n");
        sb.append("    secondaryEdge: ").append(this.toIndentedString(this.secondaryEdge)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    lineAppearanceId: ").append(this.toIndentedString(this.lineAppearanceId)).append("\n");
        sb.append("    webRtcMediaDscp: ").append(this.toIndentedString(this.webRtcMediaDscp)).append("\n");
        sb.append("    webRtcPersistentEnabled: ").append(this.toIndentedString(this.webRtcPersistentEnabled)).append("\n");
        sb.append("    webRtcForceTurn: ").append(this.toIndentedString(this.webRtcForceTurn)).append("\n");
        sb.append("    webRtcCallAppearances: ").append(this.toIndentedString(this.webRtcCallAppearances)).append("\n");
        sb.append("    webRtcRequireMediaHelper: ").append(this.toIndentedString(this.webRtcRequireMediaHelper)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        AVAILABLE("AVAILABLE"),
        ASSOCIATED("ASSOCIATED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

