/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AggregateHistoricalAvailability;
import com.mypurecloud.sdk.v2.model.SessionInfo;
import com.mypurecloud.sdk.v2.model.Snapshots;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class SessionMetaDataResult
implements Serializable {
    private SessionInfo sessionInfo = null;
    private List<Snapshots> snapshots = null;
    private Date dateForecastStart = null;
    private Date dateHistoricalStart = null;
    private AggregateHistoricalAvailability aggregateOfferedHistoricalAvailability = null;
    private AggregateHistoricalAvailability aggregateAverageHandleTimeHistoricalAvailability = null;

    public SessionMetaDataResult() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.snapshots = new ArrayList<Snapshots>();
        }
    }

    public SessionMetaDataResult sessionInfo(SessionInfo sessionInfo) {
        this.sessionInfo = sessionInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="Information about the continuous forecast session")
    @JsonProperty(value="sessionInfo")
    public SessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    public void setSessionInfo(SessionInfo sessionInfo) {
        this.sessionInfo = sessionInfo;
    }

    public SessionMetaDataResult snapshots(List<Snapshots> snapshots) {
        this.snapshots = snapshots;
        return this;
    }

    @ApiModelProperty(example="null", value="Captured snapshots")
    @JsonProperty(value="snapshots")
    public List<Snapshots> getSnapshots() {
        return this.snapshots;
    }

    public void setSnapshots(List<Snapshots> snapshots) {
        this.snapshots = snapshots;
    }

    public SessionMetaDataResult dateForecastStart(Date dateForecastStart) {
        this.dateForecastStart = dateForecastStart;
        return this;
    }

    @ApiModelProperty(example="null", value="Start date of the forecast. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateForecastStart")
    public Date getDateForecastStart() {
        return this.dateForecastStart;
    }

    public void setDateForecastStart(Date dateForecastStart) {
        this.dateForecastStart = dateForecastStart;
    }

    public SessionMetaDataResult dateHistoricalStart(Date dateHistoricalStart) {
        this.dateHistoricalStart = dateHistoricalStart;
        return this;
    }

    @ApiModelProperty(example="null", value="Start date of the oldest available historical week. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateHistoricalStart")
    public Date getDateHistoricalStart() {
        return this.dateHistoricalStart;
    }

    public void setDateHistoricalStart(Date dateHistoricalStart) {
        this.dateHistoricalStart = dateHistoricalStart;
    }

    public SessionMetaDataResult aggregateOfferedHistoricalAvailability(AggregateHistoricalAvailability aggregateOfferedHistoricalAvailability) {
        this.aggregateOfferedHistoricalAvailability = aggregateOfferedHistoricalAvailability;
        return this;
    }

    @ApiModelProperty(example="null", value="Total historical availability for offered metric across all planning groups")
    @JsonProperty(value="aggregateOfferedHistoricalAvailability")
    public AggregateHistoricalAvailability getAggregateOfferedHistoricalAvailability() {
        return this.aggregateOfferedHistoricalAvailability;
    }

    public void setAggregateOfferedHistoricalAvailability(AggregateHistoricalAvailability aggregateOfferedHistoricalAvailability) {
        this.aggregateOfferedHistoricalAvailability = aggregateOfferedHistoricalAvailability;
    }

    public SessionMetaDataResult aggregateAverageHandleTimeHistoricalAvailability(AggregateHistoricalAvailability aggregateAverageHandleTimeHistoricalAvailability) {
        this.aggregateAverageHandleTimeHistoricalAvailability = aggregateAverageHandleTimeHistoricalAvailability;
        return this;
    }

    @ApiModelProperty(example="null", value="Total historical availability for average handle time metric across all planning groups")
    @JsonProperty(value="aggregateAverageHandleTimeHistoricalAvailability")
    public AggregateHistoricalAvailability getAggregateAverageHandleTimeHistoricalAvailability() {
        return this.aggregateAverageHandleTimeHistoricalAvailability;
    }

    public void setAggregateAverageHandleTimeHistoricalAvailability(AggregateHistoricalAvailability aggregateAverageHandleTimeHistoricalAvailability) {
        this.aggregateAverageHandleTimeHistoricalAvailability = aggregateAverageHandleTimeHistoricalAvailability;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionMetaDataResult sessionMetaDataResult = (SessionMetaDataResult)o;
        return Objects.equals(this.sessionInfo, sessionMetaDataResult.sessionInfo) && Objects.equals(this.snapshots, sessionMetaDataResult.snapshots) && Objects.equals(this.dateForecastStart, sessionMetaDataResult.dateForecastStart) && Objects.equals(this.dateHistoricalStart, sessionMetaDataResult.dateHistoricalStart) && Objects.equals(this.aggregateOfferedHistoricalAvailability, sessionMetaDataResult.aggregateOfferedHistoricalAvailability) && Objects.equals(this.aggregateAverageHandleTimeHistoricalAvailability, sessionMetaDataResult.aggregateAverageHandleTimeHistoricalAvailability);
    }

    public int hashCode() {
        return Objects.hash(this.sessionInfo, this.snapshots, this.dateForecastStart, this.dateHistoricalStart, this.aggregateOfferedHistoricalAvailability, this.aggregateAverageHandleTimeHistoricalAvailability);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SessionMetaDataResult {\n");
        sb.append("    sessionInfo: ").append(this.toIndentedString(this.sessionInfo)).append("\n");
        sb.append("    snapshots: ").append(this.toIndentedString(this.snapshots)).append("\n");
        sb.append("    dateForecastStart: ").append(this.toIndentedString(this.dateForecastStart)).append("\n");
        sb.append("    dateHistoricalStart: ").append(this.toIndentedString(this.dateHistoricalStart)).append("\n");
        sb.append("    aggregateOfferedHistoricalAvailability: ").append(this.toIndentedString(this.aggregateOfferedHistoricalAvailability)).append("\n");
        sb.append("    aggregateAverageHandleTimeHistoricalAvailability: ").append(this.toIndentedString(this.aggregateAverageHandleTimeHistoricalAvailability)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

