/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.NluDomainVersion;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class NluDomain
implements Serializable {
    private String id = null;
    private String name = null;
    private String language = null;
    private NluDomainVersion draftVersion = null;
    private NluDomainVersion lastPublishedVersion = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private String engineVersion = null;
    private String selfUri = null;

    public NluDomain() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public NluDomain name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the NLU domain.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NluDomain language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(example="null", value="The language culture of the NLU domain, e.g. `en-us`, `de-de`.")
    @JsonProperty(value="language")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    @ApiModelProperty(example="null", value="The draft version of that NLU domain.")
    @JsonProperty(value="draftVersion")
    public NluDomainVersion getDraftVersion() {
        return this.draftVersion;
    }

    @ApiModelProperty(example="null", value="The last published version of that NLU domain.")
    @JsonProperty(value="lastPublishedVersion")
    public NluDomainVersion getLastPublishedVersion() {
        return this.lastPublishedVersion;
    }

    @ApiModelProperty(example="null", value="The date when the NLU domain was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="The date when the NLU domain was updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public NluDomain engineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
        return this;
    }

    @ApiModelProperty(example="null", value="The version of the NLU engine to use.")
    @JsonProperty(value="engineVersion")
    public String getEngineVersion() {
        return this.engineVersion;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NluDomain nluDomain = (NluDomain)o;
        return Objects.equals(this.id, nluDomain.id) && Objects.equals(this.name, nluDomain.name) && Objects.equals(this.language, nluDomain.language) && Objects.equals(this.draftVersion, nluDomain.draftVersion) && Objects.equals(this.lastPublishedVersion, nluDomain.lastPublishedVersion) && Objects.equals(this.dateCreated, nluDomain.dateCreated) && Objects.equals(this.dateModified, nluDomain.dateModified) && Objects.equals(this.engineVersion, nluDomain.engineVersion) && Objects.equals(this.selfUri, nluDomain.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.language, this.draftVersion, this.lastPublishedVersion, this.dateCreated, this.dateModified, this.engineVersion, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NluDomain {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    draftVersion: ").append(this.toIndentedString(this.draftVersion)).append("\n");
        sb.append("    lastPublishedVersion: ").append(this.toIndentedString(this.lastPublishedVersion)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    engineVersion: ").append(this.toIndentedString(this.engineVersion)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

