/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class EventQueryRequest
implements Serializable {
    private String interval = null;
    private List<String> eventDefinitionIds = null;
    private String searchTerm = null;
    private SortOrderEnum sortOrder = null;

    public EventQueryRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.eventDefinitionIds = new ArrayList<String>();
        }
    }

    public EventQueryRequest interval(String interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Date and time range to query. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss")
    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public EventQueryRequest eventDefinitionIds(List<String> eventDefinitionIds) {
        this.eventDefinitionIds = eventDefinitionIds;
        return this;
    }

    @ApiModelProperty(example="null", value="Filter events by a list of event definition ids")
    @JsonProperty(value="eventDefinitionIds")
    public List<String> getEventDefinitionIds() {
        return this.eventDefinitionIds;
    }

    public void setEventDefinitionIds(List<String> eventDefinitionIds) {
        this.eventDefinitionIds = eventDefinitionIds;
    }

    public EventQueryRequest searchTerm(String searchTerm) {
        this.searchTerm = searchTerm;
        return this;
    }

    @ApiModelProperty(example="null", value="Only return events that contain the search term")
    @JsonProperty(value="searchTerm")
    public String getSearchTerm() {
        return this.searchTerm;
    }

    public void setSearchTerm(String searchTerm) {
        this.searchTerm = searchTerm;
    }

    public EventQueryRequest sortOrder(SortOrderEnum sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    @ApiModelProperty(example="null", value="Order of results. Default order is DESC.")
    @JsonProperty(value="sortOrder")
    public SortOrderEnum getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortOrderEnum sortOrder) {
        this.sortOrder = sortOrder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventQueryRequest eventQueryRequest = (EventQueryRequest)o;
        return Objects.equals(this.interval, eventQueryRequest.interval) && Objects.equals(this.eventDefinitionIds, eventQueryRequest.eventDefinitionIds) && Objects.equals(this.searchTerm, eventQueryRequest.searchTerm) && Objects.equals((Object)this.sortOrder, (Object)eventQueryRequest.sortOrder);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.interval, this.eventDefinitionIds, this.searchTerm, this.sortOrder});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventQueryRequest {\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    eventDefinitionIds: ").append(this.toIndentedString(this.eventDefinitionIds)).append("\n");
        sb.append("    searchTerm: ").append(this.toIndentedString(this.searchTerm)).append("\n");
        sb.append("    sortOrder: ").append(this.toIndentedString((Object)this.sortOrder)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SortOrderEnumDeserializer.class)
    public static enum SortOrderEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ASC("ASC"),
        DESC("DESC");

        private String value;

        private SortOrderEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SortOrderEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SortOrderEnum value : SortOrderEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SortOrderEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SortOrderEnumDeserializer
    extends StdDeserializer<SortOrderEnum> {
        public SortOrderEnumDeserializer() {
            super(SortOrderEnumDeserializer.class);
        }

        public SortOrderEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SortOrderEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

