/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.CriteriaItem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A group of logical or a singular criteria used to create a query of executionData")
public class CriteriaGroup
implements Serializable {
    private List<CriteriaItem> and = null;
    private List<CriteriaItem> or = null;
    private List<CriteriaItem> not = null;
    private CriteriaItem criteria = null;

    public CriteriaGroup() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.and = new ArrayList<CriteriaItem>();
            this.or = new ArrayList<CriteriaItem>();
            this.not = new ArrayList<CriteriaItem>();
        }
    }

    public CriteriaGroup and(List<CriteriaItem> and) {
        this.and = and;
        return this;
    }

    @ApiModelProperty(example="null", value="These criteriaItems will be AND'd together to find a match.")
    @JsonProperty(value="and")
    public List<CriteriaItem> getAnd() {
        return this.and;
    }

    public void setAnd(List<CriteriaItem> and) {
        this.and = and;
    }

    public CriteriaGroup or(List<CriteriaItem> or) {
        this.or = or;
        return this;
    }

    @ApiModelProperty(example="null", value="These criteriaItems will be OR'd together to find a match.")
    @JsonProperty(value="or")
    public List<CriteriaItem> getOr() {
        return this.or;
    }

    public void setOr(List<CriteriaItem> or) {
        this.or = or;
    }

    public CriteriaGroup not(List<CriteriaItem> not) {
        this.not = not;
        return this;
    }

    @ApiModelProperty(example="null", value="These criteriaItems must all be false to find a match.")
    @JsonProperty(value="not")
    public List<CriteriaItem> getNot() {
        return this.not;
    }

    public void setNot(List<CriteriaItem> not) {
        this.not = not;
    }

    public CriteriaGroup criteria(CriteriaItem criteria) {
        this.criteria = criteria;
        return this;
    }

    @ApiModelProperty(example="null", value="A singular critieriaItem to match.")
    @JsonProperty(value="criteria")
    public CriteriaItem getCriteria() {
        return this.criteria;
    }

    public void setCriteria(CriteriaItem criteria) {
        this.criteria = criteria;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CriteriaGroup criteriaGroup = (CriteriaGroup)o;
        return Objects.equals(this.and, criteriaGroup.and) && Objects.equals(this.or, criteriaGroup.or) && Objects.equals(this.not, criteriaGroup.not) && Objects.equals(this.criteria, criteriaGroup.criteria);
    }

    public int hashCode() {
        return Objects.hash(this.and, this.or, this.not, this.criteria);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CriteriaGroup {\n");
        sb.append("    and: ").append(this.toIndentedString(this.and)).append("\n");
        sb.append("    or: ").append(this.toIndentedString(this.or)).append("\n");
        sb.append("    not: ").append(this.toIndentedString(this.not)).append("\n");
        sb.append("    criteria: ").append(this.toIndentedString(this.criteria)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

