/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ConversationContentDatePickerAvailableTime;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@ApiModel(description="DateTimePicker content object.")
public class ConversationContentDatePicker
implements Serializable {
    private String title = null;
    private String subtitle = null;
    private String imageUrl = null;
    private Date dateMinimum = null;
    private Date dateMaximum = null;
    private List<ConversationContentDatePickerAvailableTime> availableTimes = null;

    public ConversationContentDatePicker() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.availableTimes = new ArrayList<ConversationContentDatePickerAvailableTime>();
        }
    }

    public ConversationContentDatePicker title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="null", value="Text to show in the title.")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ConversationContentDatePicker subtitle(String subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    @ApiModelProperty(example="null", value="Text to show in the description.")
    @JsonProperty(value="subtitle")
    public String getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public ConversationContentDatePicker imageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
        return this;
    }

    @ApiModelProperty(example="null", value="URL of an image")
    @JsonProperty(value="imageUrl")
    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public ConversationContentDatePicker dateMinimum(Date dateMinimum) {
        this.dateMinimum = dateMinimum;
        return this;
    }

    @ApiModelProperty(example="null", value="The minimum Date Enabled in the datepicker calendar, format: ISO 8601.")
    @JsonProperty(value="dateMinimum")
    public Date getDateMinimum() {
        return this.dateMinimum;
    }

    public void setDateMinimum(Date dateMinimum) {
        this.dateMinimum = dateMinimum;
    }

    public ConversationContentDatePicker dateMaximum(Date dateMaximum) {
        this.dateMaximum = dateMaximum;
        return this;
    }

    @ApiModelProperty(example="null", value="The maximum Date Enabled in the datepicker calendar, format: ISO 8601.")
    @JsonProperty(value="dateMaximum")
    public Date getDateMaximum() {
        return this.dateMaximum;
    }

    public void setDateMaximum(Date dateMaximum) {
        this.dateMaximum = dateMaximum;
    }

    public ConversationContentDatePicker availableTimes(List<ConversationContentDatePickerAvailableTime> availableTimes) {
        this.availableTimes = availableTimes;
        return this;
    }

    @ApiModelProperty(example="null", value="An array of available times objects.")
    @JsonProperty(value="availableTimes")
    public List<ConversationContentDatePickerAvailableTime> getAvailableTimes() {
        return this.availableTimes;
    }

    public void setAvailableTimes(List<ConversationContentDatePickerAvailableTime> availableTimes) {
        this.availableTimes = availableTimes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationContentDatePicker conversationContentDatePicker = (ConversationContentDatePicker)o;
        return Objects.equals(this.title, conversationContentDatePicker.title) && Objects.equals(this.subtitle, conversationContentDatePicker.subtitle) && Objects.equals(this.imageUrl, conversationContentDatePicker.imageUrl) && Objects.equals(this.dateMinimum, conversationContentDatePicker.dateMinimum) && Objects.equals(this.dateMaximum, conversationContentDatePicker.dateMaximum) && Objects.equals(this.availableTimes, conversationContentDatePicker.availableTimes);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.subtitle, this.imageUrl, this.dateMinimum, this.dateMaximum, this.availableTimes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationContentDatePicker {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    subtitle: ").append(this.toIndentedString(this.subtitle)).append("\n");
        sb.append("    imageUrl: ").append(this.toIndentedString(this.imageUrl)).append("\n");
        sb.append("    dateMinimum: ").append(this.toIndentedString(this.dateMinimum)).append("\n");
        sb.append("    dateMaximum: ").append(this.toIndentedString(this.dateMaximum)).append("\n");
        sb.append("    availableTimes: ").append(this.toIndentedString(this.availableTimes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

