/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.PinnedMessageRequest;
import java.util.HashMap;
import java.util.Map;

public class PostChatsRoomMessagesPinsRequest {
    private String roomJid;
    private PinnedMessageRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getRoomJid() {
        return this.roomJid;
    }

    public void setRoomJid(String roomJid) {
        this.roomJid = roomJid;
    }

    public PostChatsRoomMessagesPinsRequest withRoomJid(String roomJid) {
        this.setRoomJid(roomJid);
        return this;
    }

    public PinnedMessageRequest getBody() {
        return this.body;
    }

    public void setBody(PinnedMessageRequest body) {
        this.body = body;
    }

    public PostChatsRoomMessagesPinsRequest withBody(PinnedMessageRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostChatsRoomMessagesPinsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<PinnedMessageRequest> withHttpInfo() {
        if (this.roomJid == null) {
            throw new IllegalStateException("Missing the required parameter 'roomJid' when building request for PostChatsRoomMessagesPinsRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostChatsRoomMessagesPinsRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/chats/rooms/{roomJid}/messages/pins").withPathParameter("roomJid", this.roomJid).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String roomJid, PinnedMessageRequest body) {
        return new Builder().withRequiredParams(roomJid, body);
    }

    public static class Builder {
        private final PostChatsRoomMessagesPinsRequest request = new PostChatsRoomMessagesPinsRequest();

        private Builder() {
        }

        public Builder withRoomJid(String roomJid) {
            this.request.setRoomJid(roomJid);
            return this;
        }

        public Builder withBody(PinnedMessageRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String roomJid, PinnedMessageRequest body) {
            this.request.setRoomJid(roomJid);
            this.request.setBody(body);
            return this;
        }

        public PostChatsRoomMessagesPinsRequest build() {
            if (this.request.roomJid == null) {
                throw new IllegalStateException("Missing the required parameter 'roomJid' when building request for PostChatsRoomMessagesPinsRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostChatsRoomMessagesPinsRequest.");
            }
            return this.request;
        }
    }
}

