/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.KnowledgeDocumentReq;
import java.util.HashMap;
import java.util.Map;

public class PatchKnowledgeKnowledgebaseDocumentRequest {
    private String knowledgeBaseId;
    private String documentId;
    private KnowledgeDocumentReq body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getKnowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public void setKnowledgeBaseId(String knowledgeBaseId) {
        this.knowledgeBaseId = knowledgeBaseId;
    }

    public PatchKnowledgeKnowledgebaseDocumentRequest withKnowledgeBaseId(String knowledgeBaseId) {
        this.setKnowledgeBaseId(knowledgeBaseId);
        return this;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public PatchKnowledgeKnowledgebaseDocumentRequest withDocumentId(String documentId) {
        this.setDocumentId(documentId);
        return this;
    }

    public KnowledgeDocumentReq getBody() {
        return this.body;
    }

    public void setBody(KnowledgeDocumentReq body) {
        this.body = body;
    }

    public PatchKnowledgeKnowledgebaseDocumentRequest withBody(KnowledgeDocumentReq body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchKnowledgeKnowledgebaseDocumentRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<KnowledgeDocumentReq> withHttpInfo() {
        if (this.knowledgeBaseId == null) {
            throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for PatchKnowledgeKnowledgebaseDocumentRequest.");
        }
        if (this.documentId == null) {
            throw new IllegalStateException("Missing the required parameter 'documentId' when building request for PatchKnowledgeKnowledgebaseDocumentRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchKnowledgeKnowledgebaseDocumentRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/documents/{documentId}").withPathParameter("knowledgeBaseId", this.knowledgeBaseId).withPathParameter("documentId", this.documentId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String knowledgeBaseId, String documentId, KnowledgeDocumentReq body) {
        return new Builder().withRequiredParams(knowledgeBaseId, documentId, body);
    }

    public static class Builder {
        private final PatchKnowledgeKnowledgebaseDocumentRequest request = new PatchKnowledgeKnowledgebaseDocumentRequest();

        private Builder() {
        }

        public Builder withKnowledgeBaseId(String knowledgeBaseId) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            return this;
        }

        public Builder withDocumentId(String documentId) {
            this.request.setDocumentId(documentId);
            return this;
        }

        public Builder withBody(KnowledgeDocumentReq body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String knowledgeBaseId, String documentId, KnowledgeDocumentReq body) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            this.request.setDocumentId(documentId);
            this.request.setBody(body);
            return this;
        }

        public PatchKnowledgeKnowledgebaseDocumentRequest build() {
            if (this.request.knowledgeBaseId == null) {
                throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for PatchKnowledgeKnowledgebaseDocumentRequest.");
            }
            if (this.request.documentId == null) {
                throw new IllegalStateException("Missing the required parameter 'documentId' when building request for PatchKnowledgeKnowledgebaseDocumentRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchKnowledgeKnowledgebaseDocumentRequest.");
            }
            return this.request;
        }
    }
}

