/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetScimV2SchemaRequest {
    private String schemaId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getSchemaId() {
        return this.schemaId;
    }

    public void setSchemaId(String schemaId) {
        this.schemaId = schemaId;
    }

    public GetScimV2SchemaRequest withSchemaId(String schemaId) {
        this.setSchemaId(schemaId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetScimV2SchemaRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.schemaId == null) {
            throw new IllegalStateException("Missing the required parameter 'schemaId' when building request for GetScimV2SchemaRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/scim/v2/schemas/{schemaId}").withPathParameter("schemaId", this.schemaId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/scim+json", "application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String schemaId) {
        return new Builder().withRequiredParams(schemaId);
    }

    public static class Builder {
        private final GetScimV2SchemaRequest request = new GetScimV2SchemaRequest();

        private Builder() {
        }

        public Builder withSchemaId(String schemaId) {
            this.request.setSchemaId(schemaId);
            return this;
        }

        public Builder withSchemaId(schemaIdValues schemaId) {
            this.request.setSchemaId(schemaId.toString());
            return this;
        }

        public Builder withRequiredParams(String schemaId) {
            this.request.setSchemaId(schemaId);
            return this;
        }

        public GetScimV2SchemaRequest build() {
            if (this.request.schemaId == null) {
                throw new IllegalStateException("Missing the required parameter 'schemaId' when building request for GetScimV2SchemaRequest.");
            }
            return this.request;
        }
    }

    public static enum schemaIdValues {
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_USER("urn:ietf:params:scim:schemas:core:2.0:User"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_GROUP("urn:ietf:params:scim:schemas:core:2.0:Group"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_SERVICEPROVIDERCONFIG("urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_RESOURCETYPE("urn:ietf:params:scim:schemas:core:2.0:ResourceType"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_SCHEMA("urn:ietf:params:scim:schemas:core:2.0:Schema"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_EXTENSION_ENTERPRISE_2_0_USER("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_EXTENSION_GENESYS_PURECLOUD_2_0_USER("urn:ietf:params:scim:schemas:extension:genesys:purecloud:2.0:User");

        private String value;

        private schemaIdValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static schemaIdValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (schemaIdValues value : schemaIdValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return schemaIdValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

