/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.TextBotUserAgent;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Channel information relevant to a bot flow.")
public class TextBotChannel
implements Serializable {
    private NameEnum name = null;
    private List<InputModesEnum> inputModes = new ArrayList<InputModesEnum>();
    private List<OutputModesEnum> outputModes = new ArrayList<OutputModesEnum>();
    private TextBotUserAgent userAgent = null;

    public TextBotChannel name(NameEnum name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the channel.")
    @JsonProperty(value="name")
    public NameEnum getName() {
        return this.name;
    }

    public void setName(NameEnum name) {
        this.name = name;
    }

    public TextBotChannel inputModes(List<InputModesEnum> inputModes) {
        this.inputModes = inputModes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The input modes for the channel.")
    @JsonProperty(value="inputModes")
    public List<InputModesEnum> getInputModes() {
        return this.inputModes;
    }

    public void setInputModes(List<InputModesEnum> inputModes) {
        this.inputModes = inputModes;
    }

    public TextBotChannel outputModes(List<OutputModesEnum> outputModes) {
        this.outputModes = outputModes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The output modes for the channel.")
    @JsonProperty(value="outputModes")
    public List<OutputModesEnum> getOutputModes() {
        return this.outputModes;
    }

    public void setOutputModes(List<OutputModesEnum> outputModes) {
        this.outputModes = outputModes;
    }

    public TextBotChannel userAgent(TextBotUserAgent userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Information about the end user agent calling the bot flow.")
    @JsonProperty(value="userAgent")
    public TextBotUserAgent getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(TextBotUserAgent userAgent) {
        this.userAgent = userAgent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextBotChannel textBotChannel = (TextBotChannel)o;
        return Objects.equals((Object)this.name, (Object)textBotChannel.name) && Objects.equals(this.inputModes, textBotChannel.inputModes) && Objects.equals(this.outputModes, textBotChannel.outputModes) && Objects.equals(this.userAgent, textBotChannel.userAgent);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.inputModes, this.outputModes, this.userAgent});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextBotChannel {\n");
        sb.append("    name: ").append(this.toIndentedString((Object)this.name)).append("\n");
        sb.append("    inputModes: ").append(this.toIndentedString(this.inputModes)).append("\n");
        sb.append("    outputModes: ").append(this.toIndentedString(this.outputModes)).append("\n");
        sb.append("    userAgent: ").append(this.toIndentedString(this.userAgent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=NameEnumDeserializer.class)
    public static enum NameEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CHAT("Chat"),
        CALL("Call"),
        MESSAGING("Messaging");

        private String value;

        private NameEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static NameEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (NameEnum value : NameEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return NameEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=OutputModesEnumDeserializer.class)
    public static enum OutputModesEnum {
        TEXT("Text");

        private String value;

        private OutputModesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OutputModesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OutputModesEnum value : OutputModesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OutputModesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class OutputModesEnumDeserializer
    extends StdDeserializer<OutputModesEnum> {
        public OutputModesEnumDeserializer() {
            super(OutputModesEnumDeserializer.class);
        }

        public OutputModesEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OutputModesEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=InputModesEnumDeserializer.class)
    public static enum InputModesEnum {
        TEXT("Text");

        private String value;

        private InputModesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static InputModesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (InputModesEnum value : InputModesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return InputModesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class InputModesEnumDeserializer
    extends StdDeserializer<InputModesEnum> {
        public InputModesEnumDeserializer() {
            super(InputModesEnumDeserializer.class);
        }

        public InputModesEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return InputModesEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class NameEnumDeserializer
    extends StdDeserializer<NameEnum> {
        public NameEnumDeserializer() {
            super(NameEnumDeserializer.class);
        }

        public NameEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return NameEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

