/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.SocialMediaQueryFilter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class SocialMediaAsyncDetailQuery
implements Serializable {
    private String interval = null;
    private String timeZone = null;
    private SocialMediaQueryFilter filter = null;
    private Integer pageSize = null;
    private OrderEnum order = null;

    public SocialMediaAsyncDetailQuery interval(String interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Behaves like one clause in a SQL WHERE. Specifies the date and time range of data being queried. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss")
    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public SocialMediaAsyncDetailQuery timeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @ApiModelProperty(example="null", value="Time zone context used to calculate response intervals (this allows resolving DST changes). The interval offset is used even when timeZone is specified. Default is UTC. Time zones are represented as a string of the zone name as found in the IANA time zone database. For example: UTC, Etc/UTC, or Europe/London")
    @JsonProperty(value="timeZone")
    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public SocialMediaAsyncDetailQuery filter(SocialMediaQueryFilter filter) {
        this.filter = filter;
        return this;
    }

    @ApiModelProperty(example="null", value="Behaves like a SQL WHERE clause. This is ANDed with the interval parameter. Expresses boolean logical predicates as well as dimensional filters")
    @JsonProperty(value="filter")
    public SocialMediaQueryFilter getFilter() {
        return this.filter;
    }

    public void setFilter(SocialMediaQueryFilter filter) {
        this.filter = filter;
    }

    public SocialMediaAsyncDetailQuery pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of results per page")
    @JsonProperty(value="pageSize")
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public SocialMediaAsyncDetailQuery order(OrderEnum order) {
        this.order = order;
        return this;
    }

    @ApiModelProperty(example="null", value="Sorting of results based on time")
    @JsonProperty(value="order")
    public OrderEnum getOrder() {
        return this.order;
    }

    public void setOrder(OrderEnum order) {
        this.order = order;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SocialMediaAsyncDetailQuery socialMediaAsyncDetailQuery = (SocialMediaAsyncDetailQuery)o;
        return Objects.equals(this.interval, socialMediaAsyncDetailQuery.interval) && Objects.equals(this.timeZone, socialMediaAsyncDetailQuery.timeZone) && Objects.equals(this.filter, socialMediaAsyncDetailQuery.filter) && Objects.equals(this.pageSize, socialMediaAsyncDetailQuery.pageSize) && Objects.equals((Object)this.order, (Object)socialMediaAsyncDetailQuery.order);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.interval, this.timeZone, this.filter, this.pageSize, this.order});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SocialMediaAsyncDetailQuery {\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    order: ").append(this.toIndentedString((Object)this.order)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=OrderEnumDeserializer.class)
    public static enum OrderEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ASC("asc"),
        DESC("desc");

        private String value;

        private OrderEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OrderEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OrderEnum value : OrderEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OrderEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class OrderEnumDeserializer
    extends StdDeserializer<OrderEnum> {
        public OrderEnumDeserializer() {
            super(OrderEnumDeserializer.class);
        }

        public OrderEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OrderEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

