/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.Alteration;
import com.mypurecloud.sdk.v2.model.NextOccurrenceDetails;
import com.mypurecloud.sdk.v2.model.Pattern;
import com.mypurecloud.sdk.v2.model.Range;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Reoccurrence
implements Serializable {
    private String id = null;
    private String start = null;
    private String end = null;
    private String timeZone = null;
    private Pattern pattern = null;
    private Range range = null;
    private List<Alteration> alterations = new ArrayList<Alteration>();
    private NextOccurrenceDetails nextOccurrenceDetails = null;

    public Reoccurrence id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Reoccurrence start(String start) {
        this.start = start;
        return this;
    }

    @ApiModelProperty(example="2023-11-21T16:30:25", required=true, value="The start date time of the initial occurrence as an ISO-8601 string in the format YYYY-MM-DDThh:mm:ss")
    @JsonProperty(value="start")
    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public Reoccurrence end(String end) {
        this.end = end;
        return this;
    }

    @ApiModelProperty(example="2023-11-21T16:30:25", required=true, value="The end date time of the initial occurrence as an ISO-8601 string in the format YYYY-MM-DDThh:mm:ss")
    @JsonProperty(value="end")
    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public Reoccurrence timeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @ApiModelProperty(example="America/New_York", value="The time zone for the recurrence. The time zone of the recurrence is determined by prioritizing the recurrence's time zone if specified, then the schedule's time zone if set, and finally defaulting to UTC if neither defines a time zone. See here for a list of valid time zones https://www.iana.org/time-zones")
    @JsonProperty(value="timeZone")
    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public Reoccurrence pattern(Pattern pattern) {
        this.pattern = pattern;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The schedule pattern e.g.: Daily/Weekly")
    @JsonProperty(value="pattern")
    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public Reoccurrence range(Range range) {
        this.range = range;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The schedule range e.g.: EndDate/NoEnd/Numbered")
    @JsonProperty(value="range")
    public Range getRange() {
        return this.range;
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public Reoccurrence alterations(List<Alteration> alterations) {
        this.alterations = alterations;
        return this;
    }

    @ApiModelProperty(example="null", value="Modifications to the original recurrence schedule (Exclusions/Inclusions)")
    @JsonProperty(value="alterations")
    public List<Alteration> getAlterations() {
        return this.alterations;
    }

    public void setAlterations(List<Alteration> alterations) {
        this.alterations = alterations;
    }

    @ApiModelProperty(example="null", value="The next occurrence details for the next start and end occurrences for the recurrence")
    @JsonProperty(value="nextOccurrenceDetails")
    public NextOccurrenceDetails getNextOccurrenceDetails() {
        return this.nextOccurrenceDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reoccurrence reoccurrence = (Reoccurrence)o;
        return Objects.equals(this.id, reoccurrence.id) && Objects.equals(this.start, reoccurrence.start) && Objects.equals(this.end, reoccurrence.end) && Objects.equals(this.timeZone, reoccurrence.timeZone) && Objects.equals(this.pattern, reoccurrence.pattern) && Objects.equals(this.range, reoccurrence.range) && Objects.equals(this.alterations, reoccurrence.alterations) && Objects.equals(this.nextOccurrenceDetails, reoccurrence.nextOccurrenceDetails);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.start, this.end, this.timeZone, this.pattern, this.range, this.alterations, this.nextOccurrenceDetails);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Reoccurrence {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("    end: ").append(this.toIndentedString(this.end)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    pattern: ").append(this.toIndentedString(this.pattern)).append("\n");
        sb.append("    range: ").append(this.toIndentedString(this.range)).append("\n");
        sb.append("    alterations: ").append(this.toIndentedString(this.alterations)).append("\n");
        sb.append("    nextOccurrenceDetails: ").append(this.toIndentedString(this.nextOccurrenceDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

