/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.NotificationTemplateParameter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Template button object")
public class NotificationTemplateButton
implements Serializable {
    private TypeEnum type = null;
    private String text = null;
    private Long index = null;
    private String phoneNumber = null;
    private String url = null;
    private List<NotificationTemplateParameter> parameters = new ArrayList<NotificationTemplateParameter>();

    public NotificationTemplateButton type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Specifies the type of the button.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public NotificationTemplateButton text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="null", value="Button text message.")
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public NotificationTemplateButton index(Long index) {
        this.index = index;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="index of the button in the list.")
    @JsonProperty(value="index")
    public Long getIndex() {
        return this.index;
    }

    public void setIndex(Long index) {
        this.index = index;
    }

    public NotificationTemplateButton phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="Button phone number.")
    @JsonProperty(value="phoneNumber")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public NotificationTemplateButton url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="null", value="Button URL link.")
    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public NotificationTemplateButton parameters(List<NotificationTemplateParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    @ApiModelProperty(example="null", value="Template parameters for placeholders in the button.")
    @JsonProperty(value="parameters")
    public List<NotificationTemplateParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<NotificationTemplateParameter> parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationTemplateButton notificationTemplateButton = (NotificationTemplateButton)o;
        return Objects.equals((Object)this.type, (Object)notificationTemplateButton.type) && Objects.equals(this.text, notificationTemplateButton.text) && Objects.equals(this.index, notificationTemplateButton.index) && Objects.equals(this.phoneNumber, notificationTemplateButton.phoneNumber) && Objects.equals(this.url, notificationTemplateButton.url) && Objects.equals(this.parameters, notificationTemplateButton.parameters);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.text, this.index, this.phoneNumber, this.url, this.parameters});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotificationTemplateButton {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    index: ").append(this.toIndentedString(this.index)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        QUICKREPLY("QuickReply"),
        PHONENUMBER("PhoneNumber"),
        URL("Url");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

