/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.KnowledgeConversationContext;
import com.mypurecloud.sdk.v2.model.KnowledgeSearchClientApplication;
import com.mypurecloud.sdk.v2.model.PresentedKnowledgeDocument;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class KnowledgeDocumentPresentation
implements Serializable {
    private List<PresentedKnowledgeDocument> documents = new ArrayList<PresentedKnowledgeDocument>();
    private String searchId = null;
    private QueryTypeEnum queryType = null;
    private SurfacingMethodEnum surfacingMethod = null;
    private String sessionId = null;
    private KnowledgeConversationContext conversationContext = null;
    private KnowledgeSearchClientApplication application = null;

    public KnowledgeDocumentPresentation documents(List<PresentedKnowledgeDocument> documents) {
        this.documents = documents;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The presented documents")
    @JsonProperty(value="documents")
    public List<PresentedKnowledgeDocument> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<PresentedKnowledgeDocument> documents) {
        this.documents = documents;
    }

    public KnowledgeDocumentPresentation searchId(String searchId) {
        this.searchId = searchId;
        return this;
    }

    @ApiModelProperty(example="null", value="The search that surfaced the documents that were presented.")
    @JsonProperty(value="searchId")
    public String getSearchId() {
        return this.searchId;
    }

    public void setSearchId(String searchId) {
        this.searchId = searchId;
    }

    public KnowledgeDocumentPresentation queryType(QueryTypeEnum queryType) {
        this.queryType = queryType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of the query that surfaced the documents.")
    @JsonProperty(value="queryType")
    public QueryTypeEnum getQueryType() {
        return this.queryType;
    }

    public void setQueryType(QueryTypeEnum queryType) {
        this.queryType = queryType;
    }

    public KnowledgeDocumentPresentation surfacingMethod(SurfacingMethodEnum surfacingMethod) {
        this.surfacingMethod = surfacingMethod;
        return this;
    }

    @ApiModelProperty(example="null", value="The method how knowledge was surfaced. Article: Full article was shown. Snippet: A snippet from the article was shown. Highlight: A highlighted answer in a snippet was shown.")
    @JsonProperty(value="surfacingMethod")
    public SurfacingMethodEnum getSurfacingMethod() {
        return this.surfacingMethod;
    }

    public void setSurfacingMethod(SurfacingMethodEnum surfacingMethod) {
        this.surfacingMethod = surfacingMethod;
    }

    @ApiModelProperty(example="null", value="Knowledge session ID.")
    @JsonProperty(value="sessionId")
    public String getSessionId() {
        return this.sessionId;
    }

    public KnowledgeDocumentPresentation conversationContext(KnowledgeConversationContext conversationContext) {
        this.conversationContext = conversationContext;
        return this;
    }

    @ApiModelProperty(example="null", value="Conversation context information if the documents were presented in the context of a conversation.")
    @JsonProperty(value="conversationContext")
    public KnowledgeConversationContext getConversationContext() {
        return this.conversationContext;
    }

    public void setConversationContext(KnowledgeConversationContext conversationContext) {
        this.conversationContext = conversationContext;
    }

    public KnowledgeDocumentPresentation application(KnowledgeSearchClientApplication application) {
        this.application = application;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The client application in which the documents were presented.")
    @JsonProperty(value="application")
    public KnowledgeSearchClientApplication getApplication() {
        return this.application;
    }

    public void setApplication(KnowledgeSearchClientApplication application) {
        this.application = application;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeDocumentPresentation knowledgeDocumentPresentation = (KnowledgeDocumentPresentation)o;
        return Objects.equals(this.documents, knowledgeDocumentPresentation.documents) && Objects.equals(this.searchId, knowledgeDocumentPresentation.searchId) && Objects.equals((Object)this.queryType, (Object)knowledgeDocumentPresentation.queryType) && Objects.equals((Object)this.surfacingMethod, (Object)knowledgeDocumentPresentation.surfacingMethod) && Objects.equals(this.sessionId, knowledgeDocumentPresentation.sessionId) && Objects.equals(this.conversationContext, knowledgeDocumentPresentation.conversationContext) && Objects.equals(this.application, knowledgeDocumentPresentation.application);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.documents, this.searchId, this.queryType, this.surfacingMethod, this.sessionId, this.conversationContext, this.application});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeDocumentPresentation {\n");
        sb.append("    documents: ").append(this.toIndentedString(this.documents)).append("\n");
        sb.append("    searchId: ").append(this.toIndentedString(this.searchId)).append("\n");
        sb.append("    queryType: ").append(this.toIndentedString((Object)this.queryType)).append("\n");
        sb.append("    surfacingMethod: ").append(this.toIndentedString((Object)this.surfacingMethod)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    conversationContext: ").append(this.toIndentedString(this.conversationContext)).append("\n");
        sb.append("    application: ").append(this.toIndentedString(this.application)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=QueryTypeEnumDeserializer.class)
    public static enum QueryTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNKNOWN("Unknown"),
        ARTICLE("Article"),
        AUTOSEARCH("AutoSearch"),
        CATEGORY("Category"),
        MANUALSEARCH("ManualSearch"),
        RECOMMENDATION("Recommendation"),
        SUGGESTION("Suggestion");

        private String value;

        private QueryTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static QueryTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (QueryTypeEnum value : QueryTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return QueryTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=SurfacingMethodEnumDeserializer.class)
    public static enum SurfacingMethodEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNKNOWN("Unknown"),
        ARTICLE("Article"),
        SNIPPET("Snippet"),
        HIGHLIGHT("Highlight");

        private String value;

        private SurfacingMethodEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SurfacingMethodEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SurfacingMethodEnum value : SurfacingMethodEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SurfacingMethodEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SurfacingMethodEnumDeserializer
    extends StdDeserializer<SurfacingMethodEnum> {
        public SurfacingMethodEnumDeserializer() {
            super(SurfacingMethodEnumDeserializer.class);
        }

        public SurfacingMethodEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SurfacingMethodEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class QueryTypeEnumDeserializer
    extends StdDeserializer<QueryTypeEnum> {
        public QueryTypeEnumDeserializer() {
            super(QueryTypeEnumDeserializer.class);
        }

        public QueryTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return QueryTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

