/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.ArchitectFlowReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class ExportDetails
implements Serializable {
    private ArchitectFlowReference flow = null;
    private String fileName = null;
    private ExportTypeEnum exportType = null;

    public ExportDetails flow(ArchitectFlowReference flow) {
        this.flow = flow;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The flow to export. If you do not provide the flow ID, you must provide both the name and type.")
    @JsonProperty(value="flow")
    public ArchitectFlowReference getFlow() {
        return this.flow;
    }

    public void setFlow(ArchitectFlowReference flow) {
        this.flow = flow;
    }

    public ExportDetails fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @ApiModelProperty(example="null", value="Name to assign to the file after download. The extension will be automatically appended based on desired export type. Must contain only alphanumeric characters, underscores, or hyphens.")
    @JsonProperty(value="fileName")
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public ExportDetails exportType(ExportTypeEnum exportType) {
        this.exportType = exportType;
        return this;
    }

    @ApiModelProperty(example="null", value="The export type for the flow. Default: 'Yaml'.")
    @JsonProperty(value="exportType")
    public ExportTypeEnum getExportType() {
        return this.exportType;
    }

    public void setExportType(ExportTypeEnum exportType) {
        this.exportType = exportType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExportDetails exportDetails = (ExportDetails)o;
        return Objects.equals(this.flow, exportDetails.flow) && Objects.equals(this.fileName, exportDetails.fileName) && Objects.equals((Object)this.exportType, (Object)exportDetails.exportType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.flow, this.fileName, this.exportType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExportDetails {\n");
        sb.append("    flow: ").append(this.toIndentedString(this.flow)).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    exportType: ").append(this.toIndentedString((Object)this.exportType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ExportTypeEnumDeserializer.class)
    public static enum ExportTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ARCHITECT("Architect"),
        YAML("Yaml");

        private String value;

        private ExportTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ExportTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ExportTypeEnum value : ExportTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ExportTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ExportTypeEnumDeserializer
    extends StdDeserializer<ExportTypeEnum> {
        public ExportTypeEnumDeserializer() {
            super(ExportTypeEnumDeserializer.class);
        }

        public ExportTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ExportTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

