/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.CampaignRuleAction;
import com.mypurecloud.sdk.v2.model.CampaignRuleCondition;
import com.mypurecloud.sdk.v2.model.CampaignRuleConditionGroup;
import com.mypurecloud.sdk.v2.model.CampaignRuleEntities;
import com.mypurecloud.sdk.v2.model.CampaignRuleExecutionSettings;
import com.mypurecloud.sdk.v2.model.CampaignRuleWarning;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class CampaignRule
implements Serializable {
    private String id = null;
    private String name = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private Integer version = null;
    private CampaignRuleEntities campaignRuleEntities = null;
    private List<CampaignRuleCondition> campaignRuleConditions = new ArrayList<CampaignRuleCondition>();
    private List<CampaignRuleAction> campaignRuleActions = new ArrayList<CampaignRuleAction>();
    private Boolean matchAnyConditions = null;
    private Boolean enabled = null;
    private CampaignRuleProcessingEnum campaignRuleProcessing = null;
    private List<CampaignRuleConditionGroup> conditionGroups = new ArrayList<CampaignRuleConditionGroup>();
    private CampaignRuleExecutionSettings executionSettings = null;
    private List<CampaignRuleWarning> warnings = new ArrayList<CampaignRuleWarning>();
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public CampaignRule name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the CampaignRule.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(example="null", value="Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public CampaignRule version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="Required for updates, must match the version number of the most recent update")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public CampaignRule campaignRuleEntities(CampaignRuleEntities campaignRuleEntities) {
        this.campaignRuleEntities = campaignRuleEntities;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The list of entities that this CampaignRule monitors.")
    @JsonProperty(value="campaignRuleEntities")
    public CampaignRuleEntities getCampaignRuleEntities() {
        return this.campaignRuleEntities;
    }

    public void setCampaignRuleEntities(CampaignRuleEntities campaignRuleEntities) {
        this.campaignRuleEntities = campaignRuleEntities;
    }

    public CampaignRule campaignRuleConditions(List<CampaignRuleCondition> campaignRuleConditions) {
        this.campaignRuleConditions = campaignRuleConditions;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The list of conditions that are evaluated on the entities.")
    @JsonProperty(value="campaignRuleConditions")
    public List<CampaignRuleCondition> getCampaignRuleConditions() {
        return this.campaignRuleConditions;
    }

    public void setCampaignRuleConditions(List<CampaignRuleCondition> campaignRuleConditions) {
        this.campaignRuleConditions = campaignRuleConditions;
    }

    public CampaignRule campaignRuleActions(List<CampaignRuleAction> campaignRuleActions) {
        this.campaignRuleActions = campaignRuleActions;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The list of actions that are executed if the conditions are satisfied.")
    @JsonProperty(value="campaignRuleActions")
    public List<CampaignRuleAction> getCampaignRuleActions() {
        return this.campaignRuleActions;
    }

    public void setCampaignRuleActions(List<CampaignRuleAction> campaignRuleActions) {
        this.campaignRuleActions = campaignRuleActions;
    }

    public CampaignRule matchAnyConditions(Boolean matchAnyConditions) {
        this.matchAnyConditions = matchAnyConditions;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="matchAnyConditions")
    public Boolean getMatchAnyConditions() {
        return this.matchAnyConditions;
    }

    public void setMatchAnyConditions(Boolean matchAnyConditions) {
        this.matchAnyConditions = matchAnyConditions;
    }

    public CampaignRule enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether or not this CampaignRule is currently enabled. Required on updates.")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public CampaignRule campaignRuleProcessing(CampaignRuleProcessingEnum campaignRuleProcessing) {
        this.campaignRuleProcessing = campaignRuleProcessing;
        return this;
    }

    @ApiModelProperty(example="null", value="CampaignRule processing algorithm")
    @JsonProperty(value="campaignRuleProcessing")
    public CampaignRuleProcessingEnum getCampaignRuleProcessing() {
        return this.campaignRuleProcessing;
    }

    public void setCampaignRuleProcessing(CampaignRuleProcessingEnum campaignRuleProcessing) {
        this.campaignRuleProcessing = campaignRuleProcessing;
    }

    public CampaignRule conditionGroups(List<CampaignRuleConditionGroup> conditionGroups) {
        this.conditionGroups = conditionGroups;
        return this;
    }

    @ApiModelProperty(example="null", value="List of condition groups that are evaluated, used only with campaignRuleProcessing=\"v2\"")
    @JsonProperty(value="conditionGroups")
    public List<CampaignRuleConditionGroup> getConditionGroups() {
        return this.conditionGroups;
    }

    public void setConditionGroups(List<CampaignRuleConditionGroup> conditionGroups) {
        this.conditionGroups = conditionGroups;
    }

    public CampaignRule executionSettings(CampaignRuleExecutionSettings executionSettings) {
        this.executionSettings = executionSettings;
        return this;
    }

    @ApiModelProperty(example="null", value="CampaignRule execution settings")
    @JsonProperty(value="executionSettings")
    public CampaignRuleExecutionSettings getExecutionSettings() {
        return this.executionSettings;
    }

    public void setExecutionSettings(CampaignRuleExecutionSettings executionSettings) {
        this.executionSettings = executionSettings;
    }

    @ApiModelProperty(example="null", value="A list of current warning conditions associated with the campaign rule.")
    @JsonProperty(value="warnings")
    public List<CampaignRuleWarning> getWarnings() {
        return this.warnings;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CampaignRule campaignRule = (CampaignRule)o;
        return Objects.equals(this.id, campaignRule.id) && Objects.equals(this.name, campaignRule.name) && Objects.equals(this.dateCreated, campaignRule.dateCreated) && Objects.equals(this.dateModified, campaignRule.dateModified) && Objects.equals(this.version, campaignRule.version) && Objects.equals(this.campaignRuleEntities, campaignRule.campaignRuleEntities) && Objects.equals(this.campaignRuleConditions, campaignRule.campaignRuleConditions) && Objects.equals(this.campaignRuleActions, campaignRule.campaignRuleActions) && Objects.equals(this.matchAnyConditions, campaignRule.matchAnyConditions) && Objects.equals(this.enabled, campaignRule.enabled) && Objects.equals((Object)this.campaignRuleProcessing, (Object)campaignRule.campaignRuleProcessing) && Objects.equals(this.conditionGroups, campaignRule.conditionGroups) && Objects.equals(this.executionSettings, campaignRule.executionSettings) && Objects.equals(this.warnings, campaignRule.warnings) && Objects.equals(this.selfUri, campaignRule.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.dateCreated, this.dateModified, this.version, this.campaignRuleEntities, this.campaignRuleConditions, this.campaignRuleActions, this.matchAnyConditions, this.enabled, this.campaignRuleProcessing, this.conditionGroups, this.executionSettings, this.warnings, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CampaignRule {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    campaignRuleEntities: ").append(this.toIndentedString(this.campaignRuleEntities)).append("\n");
        sb.append("    campaignRuleConditions: ").append(this.toIndentedString(this.campaignRuleConditions)).append("\n");
        sb.append("    campaignRuleActions: ").append(this.toIndentedString(this.campaignRuleActions)).append("\n");
        sb.append("    matchAnyConditions: ").append(this.toIndentedString(this.matchAnyConditions)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    campaignRuleProcessing: ").append(this.toIndentedString((Object)this.campaignRuleProcessing)).append("\n");
        sb.append("    conditionGroups: ").append(this.toIndentedString(this.conditionGroups)).append("\n");
        sb.append("    executionSettings: ").append(this.toIndentedString(this.executionSettings)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=CampaignRuleProcessingEnumDeserializer.class)
    public static enum CampaignRuleProcessingEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        V2("v2");

        private String value;

        private CampaignRuleProcessingEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CampaignRuleProcessingEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CampaignRuleProcessingEnum value : CampaignRuleProcessingEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CampaignRuleProcessingEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class CampaignRuleProcessingEnumDeserializer
    extends StdDeserializer<CampaignRuleProcessingEnum> {
        public CampaignRuleProcessingEnumDeserializer() {
            super(CampaignRuleProcessingEnumDeserializer.class);
        }

        public CampaignRuleProcessingEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return CampaignRuleProcessingEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

