/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.ModifiableRuleProperties;
import java.util.HashMap;
import java.util.Map;

public class PutAlertingRuleRequest {
    private String ruleId;
    private ModifiableRuleProperties body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public PutAlertingRuleRequest withRuleId(String ruleId) {
        this.setRuleId(ruleId);
        return this;
    }

    public ModifiableRuleProperties getBody() {
        return this.body;
    }

    public void setBody(ModifiableRuleProperties body) {
        this.body = body;
    }

    public PutAlertingRuleRequest withBody(ModifiableRuleProperties body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutAlertingRuleRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<ModifiableRuleProperties> withHttpInfo() {
        if (this.ruleId == null) {
            throw new IllegalStateException("Missing the required parameter 'ruleId' when building request for PutAlertingRuleRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutAlertingRuleRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/alerting/rules/{ruleId}").withPathParameter("ruleId", this.ruleId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String ruleId, ModifiableRuleProperties body) {
        return new Builder().withRequiredParams(ruleId, body);
    }

    public static class Builder {
        private final PutAlertingRuleRequest request = new PutAlertingRuleRequest();

        private Builder() {
        }

        public Builder withRuleId(String ruleId) {
            this.request.setRuleId(ruleId);
            return this;
        }

        public Builder withBody(ModifiableRuleProperties body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String ruleId, ModifiableRuleProperties body) {
            this.request.setRuleId(ruleId);
            this.request.setBody(body);
            return this;
        }

        public PutAlertingRuleRequest build() {
            if (this.request.ruleId == null) {
                throw new IllegalStateException("Missing the required parameter 'ruleId' when building request for PutAlertingRuleRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutAlertingRuleRequest.");
            }
            return this.request;
        }
    }
}

