/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetChatsUserMessageRequest {
    private String userId;
    private String messageIds;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public GetChatsUserMessageRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public String getMessageIds() {
        return this.messageIds;
    }

    public void setMessageIds(String messageIds) {
        this.messageIds = messageIds;
    }

    public GetChatsUserMessageRequest withMessageIds(String messageIds) {
        this.setMessageIds(messageIds);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetChatsUserMessageRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.userId == null) {
            throw new IllegalStateException("Missing the required parameter 'userId' when building request for GetChatsUserMessageRequest.");
        }
        if (this.messageIds == null) {
            throw new IllegalStateException("Missing the required parameter 'messageIds' when building request for GetChatsUserMessageRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/chats/users/{userId}/messages/{messageIds}").withPathParameter("userId", this.userId).withPathParameter("messageIds", this.messageIds).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String userId, String messageIds) {
        return new Builder().withRequiredParams(userId, messageIds);
    }

    public static class Builder {
        private final GetChatsUserMessageRequest request = new GetChatsUserMessageRequest();

        private Builder() {
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withMessageIds(String messageIds) {
            this.request.setMessageIds(messageIds);
            return this;
        }

        public Builder withRequiredParams(String userId, String messageIds) {
            this.request.setUserId(userId);
            this.request.setMessageIds(messageIds);
            return this;
        }

        public GetChatsUserMessageRequest build() {
            if (this.request.userId == null) {
                throw new IllegalStateException("Missing the required parameter 'userId' when building request for GetChatsUserMessageRequest.");
            }
            if (this.request.messageIds == null) {
                throw new IllegalStateException("Missing the required parameter 'messageIds' when building request for GetChatsUserMessageRequest.");
            }
            return this.request;
        }
    }
}

