/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.UserReference;
import com.mypurecloud.sdk.v2.model.WorkitemReference;
import com.mypurecloud.sdk.v2.model.WrapupIdReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class WorkitemWrapup
implements Serializable {
    private WorkitemReference workitem = null;
    private WrapupIdReference wrapupCode = null;
    private UserReference modifiedBy = null;
    private UserReference user = null;
    private Date dateModified = null;

    public WorkitemWrapup workitem(WorkitemReference workitem) {
        this.workitem = workitem;
        return this;
    }

    @ApiModelProperty(example="null", value="Workitem that the wrapup code has been added to.")
    @JsonProperty(value="workitem")
    public WorkitemReference getWorkitem() {
        return this.workitem;
    }

    public void setWorkitem(WorkitemReference workitem) {
        this.workitem = workitem;
    }

    public WorkitemWrapup wrapupCode(WrapupIdReference wrapupCode) {
        this.wrapupCode = wrapupCode;
        return this;
    }

    @ApiModelProperty(example="null", value="The wrapup code used in the workitem.")
    @JsonProperty(value="wrapupCode")
    public WrapupIdReference getWrapupCode() {
        return this.wrapupCode;
    }

    public void setWrapupCode(WrapupIdReference wrapupCode) {
        this.wrapupCode = wrapupCode;
    }

    public WorkitemWrapup modifiedBy(UserReference modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The user who added the wrapup code to the workitem.")
    @JsonProperty(value="modifiedBy")
    public UserReference getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(UserReference modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public WorkitemWrapup user(UserReference user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="The user for whom wrapup code was added. This may be the same as modifiedBy.")
    @JsonProperty(value="user")
    public UserReference getUser() {
        return this.user;
    }

    public void setUser(UserReference user) {
        this.user = user;
    }

    public WorkitemWrapup dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", value="The modified date of the Workitem when the wrapup code was added. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkitemWrapup workitemWrapup = (WorkitemWrapup)o;
        return Objects.equals(this.workitem, workitemWrapup.workitem) && Objects.equals(this.wrapupCode, workitemWrapup.wrapupCode) && Objects.equals(this.modifiedBy, workitemWrapup.modifiedBy) && Objects.equals(this.user, workitemWrapup.user) && Objects.equals(this.dateModified, workitemWrapup.dateModified);
    }

    public int hashCode() {
        return Objects.hash(this.workitem, this.wrapupCode, this.modifiedBy, this.user, this.dateModified);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkitemWrapup {\n");
        sb.append("    workitem: ").append(this.toIndentedString(this.workitem)).append("\n");
        sb.append("    wrapupCode: ").append(this.toIndentedString(this.wrapupCode)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

