/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class PredictionResults
implements Serializable {
    private IntentEnum intent = null;
    private FormulaEnum formula = null;
    private Integer estimatedWaitTimeSeconds = null;
    private AddressableEntityRef label = null;

    public PredictionResults intent(IntentEnum intent) {
        this.intent = intent;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates the media type scope of this estimated wait time")
    @JsonProperty(value="intent")
    public IntentEnum getIntent() {
        return this.intent;
    }

    public void setIntent(IntentEnum intent) {
        this.intent = intent;
    }

    public PredictionResults formula(FormulaEnum formula) {
        this.formula = formula;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Indicates the estimated wait time Formula")
    @JsonProperty(value="formula")
    public FormulaEnum getFormula() {
        return this.formula;
    }

    public void setFormula(FormulaEnum formula) {
        this.formula = formula;
    }

    public PredictionResults estimatedWaitTimeSeconds(Integer estimatedWaitTimeSeconds) {
        this.estimatedWaitTimeSeconds = estimatedWaitTimeSeconds;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Estimated wait time in seconds")
    @JsonProperty(value="estimatedWaitTimeSeconds")
    public Integer getEstimatedWaitTimeSeconds() {
        return this.estimatedWaitTimeSeconds;
    }

    public void setEstimatedWaitTimeSeconds(Integer estimatedWaitTimeSeconds) {
        this.estimatedWaitTimeSeconds = estimatedWaitTimeSeconds;
    }

    public PredictionResults label(AddressableEntityRef label) {
        this.label = label;
        return this;
    }

    @ApiModelProperty(example="null", value="This specifies the interaction label scoped to this estimated wait time calculation")
    @JsonProperty(value="label")
    public AddressableEntityRef getLabel() {
        return this.label;
    }

    public void setLabel(AddressableEntityRef label) {
        this.label = label;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PredictionResults predictionResults = (PredictionResults)o;
        return Objects.equals((Object)this.intent, (Object)predictionResults.intent) && Objects.equals((Object)this.formula, (Object)predictionResults.formula) && Objects.equals(this.estimatedWaitTimeSeconds, predictionResults.estimatedWaitTimeSeconds) && Objects.equals(this.label, predictionResults.label);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.intent, this.formula, this.estimatedWaitTimeSeconds, this.label});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PredictionResults {\n");
        sb.append("    intent: ").append(this.toIndentedString((Object)this.intent)).append("\n");
        sb.append("    formula: ").append(this.toIndentedString((Object)this.formula)).append("\n");
        sb.append("    estimatedWaitTimeSeconds: ").append(this.toIndentedString(this.estimatedWaitTimeSeconds)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=IntentEnumDeserializer.class)
    public static enum IntentEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALL("ALL"),
        CALL("CALL"),
        CALLBACK("CALLBACK"),
        CHAT("CHAT"),
        EMAIL("EMAIL"),
        SOCIALEXPRESSION("SOCIALEXPRESSION"),
        VIDEOCOMM("VIDEOCOMM"),
        MESSAGE("MESSAGE");

        private String value;

        private IntentEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static IntentEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (IntentEnum value : IntentEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return IntentEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=FormulaEnumDeserializer.class)
    public static enum FormulaEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        BEST("BEST"),
        SIMPLE("SIMPLE"),
        ABANDON("ABANDON"),
        PATIENCE_ABANDON("PATIENCE_ABANDON");

        private String value;

        private FormulaEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FormulaEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FormulaEnum value : FormulaEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FormulaEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class FormulaEnumDeserializer
    extends StdDeserializer<FormulaEnum> {
        public FormulaEnumDeserializer() {
            super(FormulaEnumDeserializer.class);
        }

        public FormulaEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FormulaEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class IntentEnumDeserializer
    extends StdDeserializer<IntentEnum> {
        public IntentEnumDeserializer() {
            super(IntentEnumDeserializer.class);
        }

        public IntentEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return IntentEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

