/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class OpenDataIngestionRuleResponse
implements Serializable {
    private String id = null;
    private String name = null;
    private String description = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private StatusEnum status = null;
    private Integer version = null;
    private DomainEntityRef externalSource = null;
    private String selfUri = null;

    public OpenDataIngestionRuleResponse id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="ID of the open data ingestion rule.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public OpenDataIngestionRuleResponse name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the data ingestion rule.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OpenDataIngestionRuleResponse description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="A description of the data ingestion rule.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public OpenDataIngestionRuleResponse dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="Timestamp indicating when the data ingestion rule was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public OpenDataIngestionRuleResponse dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", value="Timestamp indicating when the data ingestion rule was last updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public OpenDataIngestionRuleResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="The status of the data ingestion rule.")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public OpenDataIngestionRuleResponse version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="The version number of the data ingestion rule.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public OpenDataIngestionRuleResponse externalSource(DomainEntityRef externalSource) {
        this.externalSource = externalSource;
        return this;
    }

    @ApiModelProperty(example="null", value="The external source associated with this open data ingestion rule, which is used when performing identity resolution")
    @JsonProperty(value="externalSource")
    public DomainEntityRef getExternalSource() {
        return this.externalSource;
    }

    public void setExternalSource(DomainEntityRef externalSource) {
        this.externalSource = externalSource;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenDataIngestionRuleResponse openDataIngestionRuleResponse = (OpenDataIngestionRuleResponse)o;
        return Objects.equals(this.id, openDataIngestionRuleResponse.id) && Objects.equals(this.name, openDataIngestionRuleResponse.name) && Objects.equals(this.description, openDataIngestionRuleResponse.description) && Objects.equals(this.dateCreated, openDataIngestionRuleResponse.dateCreated) && Objects.equals(this.dateModified, openDataIngestionRuleResponse.dateModified) && Objects.equals((Object)this.status, (Object)openDataIngestionRuleResponse.status) && Objects.equals(this.version, openDataIngestionRuleResponse.version) && Objects.equals(this.externalSource, openDataIngestionRuleResponse.externalSource) && Objects.equals(this.selfUri, openDataIngestionRuleResponse.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.dateCreated, this.dateModified, this.status, this.version, this.externalSource, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenDataIngestionRuleResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    externalSource: ").append(this.toIndentedString(this.externalSource)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("Active"),
        DELETED("Deleted"),
        ERROR("Error"),
        PAUSED("Paused"),
        PENDING("Pending"),
        SYSTEMPAUSED("SystemPaused");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

