/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.Division;
import com.mypurecloud.sdk.v2.model.ImportStatus;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class DncListDivisionView
implements Serializable {
    private String id = null;
    private String name = null;
    private Division division = null;
    private ImportStatus importStatus = null;
    private Long size = null;
    private DncSourceTypeEnum dncSourceType = null;
    private ContactMethodEnum contactMethod = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public DncListDivisionView name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DncListDivisionView division(Division division) {
        this.division = division;
        return this;
    }

    @ApiModelProperty(example="null", value="The division to which this entity belongs.")
    @JsonProperty(value="division")
    public Division getDivision() {
        return this.division;
    }

    public void setDivision(Division division) {
        this.division = division;
    }

    @ApiModelProperty(example="null", value="The status of the import process.")
    @JsonProperty(value="importStatus")
    public ImportStatus getImportStatus() {
        return this.importStatus;
    }

    @ApiModelProperty(example="null", value="The number of contacts in the DncList.")
    @JsonProperty(value="size")
    public Long getSize() {
        return this.size;
    }

    @ApiModelProperty(example="null", value="The type of the DncList.")
    @JsonProperty(value="dncSourceType")
    public DncSourceTypeEnum getDncSourceType() {
        return this.dncSourceType;
    }

    public DncListDivisionView contactMethod(ContactMethodEnum contactMethod) {
        this.contactMethod = contactMethod;
        return this;
    }

    @ApiModelProperty(example="null", value="The contact method. Required if dncSourceType is rds.")
    @JsonProperty(value="contactMethod")
    public ContactMethodEnum getContactMethod() {
        return this.contactMethod;
    }

    public void setContactMethod(ContactMethodEnum contactMethod) {
        this.contactMethod = contactMethod;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DncListDivisionView dncListDivisionView = (DncListDivisionView)o;
        return Objects.equals(this.id, dncListDivisionView.id) && Objects.equals(this.name, dncListDivisionView.name) && Objects.equals(this.division, dncListDivisionView.division) && Objects.equals(this.importStatus, dncListDivisionView.importStatus) && Objects.equals(this.size, dncListDivisionView.size) && Objects.equals((Object)this.dncSourceType, (Object)dncListDivisionView.dncSourceType) && Objects.equals((Object)this.contactMethod, (Object)dncListDivisionView.contactMethod) && Objects.equals(this.selfUri, dncListDivisionView.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.division, this.importStatus, this.size, this.dncSourceType, this.contactMethod, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DncListDivisionView {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    division: ").append(this.toIndentedString(this.division)).append("\n");
        sb.append("    importStatus: ").append(this.toIndentedString(this.importStatus)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    dncSourceType: ").append(this.toIndentedString((Object)this.dncSourceType)).append("\n");
        sb.append("    contactMethod: ").append(this.toIndentedString((Object)this.contactMethod)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=DncSourceTypeEnumDeserializer.class)
    public static enum DncSourceTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        RDS("rds"),
        RDS_CUSTOM("rds_custom"),
        DNC_COM("dnc.com"),
        GRYPHON("gryphon");

        private String value;

        private DncSourceTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DncSourceTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DncSourceTypeEnum value : DncSourceTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DncSourceTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=ContactMethodEnumDeserializer.class)
    public static enum ContactMethodEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EMAIL("Email"),
        PHONE("Phone"),
        ANY("Any"),
        WHATSAPP("WhatsApp");

        private String value;

        private ContactMethodEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ContactMethodEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ContactMethodEnum value : ContactMethodEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ContactMethodEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ContactMethodEnumDeserializer
    extends StdDeserializer<ContactMethodEnum> {
        public ContactMethodEnumDeserializer() {
            super(ContactMethodEnumDeserializer.class);
        }

        public ContactMethodEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ContactMethodEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class DncSourceTypeEnumDeserializer
    extends StdDeserializer<DncSourceTypeEnum> {
        public DncSourceTypeEnumDeserializer() {
            super(DncSourceTypeEnumDeserializer.class);
        }

        public DncSourceTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DncSourceTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

